% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cell_coloring.R
\name{add_cell_coloring}
\alias{add_cell_coloring}
\title{Add colouring to a set of cells.}
\usage{
add_cell_coloring(
  cell_positions,
  color_cells = c("auto", "none", "grouping", "feature", "milestone", "pseudotime"),
  trajectory,
  grouping = NULL,
  groups = NULL,
  feature_oi = NULL,
  expression_source = "expression",
  pseudotime = NULL,
  color_milestones = c("auto", "given", "cubeHelix", "Set3", "rainbow"),
  milestones = NULL,
  milestone_percentages = NULL
)
}
\arguments{
\item{cell_positions}{The positions of the cells, represented by a tibble.
Must contain column \code{cell_id} (character) and may contain columns \code{from},
\code{to}, \code{pseudotime}, depending on the value of \code{color_cells}.}

\item{color_cells}{How to color the cells.
\itemize{
\item \code{"auto"}: Try to figure out how to color cells depending on whether
one of the \code{grouping}, \code{feature_io}, \code{milestones} or \code{pseudotime} parameters are defined.
\item \code{"none"}: Cells are not coloured.
\item \code{"grouping"}: Cells are coloured according to a grouping (e.g. clustering).
Either the \code{grouping} parameter or \code{trajectory$grouping} must be a named character vector.
\item \code{"feature"}: Cells are coloured according to the values of a given feature (e.g. gene expression).
Either the \code{expression_source} parameter or \code{get_expression(trajectory)} must be a matrix.
Parameter \code{feature_oi} must also be defined.
\item \code{"milestone"} (recommended): Cells are coloured according their position in the trajectory. The positioning of the
cells are determined by parameter \code{milestone_percentages} or else by \code{trajectory$milestone_percentages}. The colours
of the milestones can be determined automatically or can be specified by passing a tibble containing character columns
\code{milestone_id} and \code{color} (See \code{add_milestone_coloring()} for help in constructing this object).
\item \code{"pseudotime"}: Cells are coloured according to the pseudotime value from the root.
}}

\item{trajectory}{A dynwrap trajectory.}

\item{grouping}{A grouping of the cells (e.g. clustering) as a named character vector.}

\item{groups}{A tibble containing character columns \code{group_id} and \code{color}. If \code{NULL}, this object is inferred from the \code{grouping} itself.}

\item{feature_oi}{The name of a feature to use for colouring the cells.}

\item{expression_source}{Source of the feature expression, defaults to \code{get_expression(trajectory)}.}

\item{pseudotime}{The pseudotime from the root of the trajectory to the cells as a named numeric vector.}

\item{color_milestones}{Which palette to use for colouring the milestones
\itemize{
\item \code{auto}: Determine colours automatically. If \code{color} is already specified in
milestones tibble, this will be used. Otherwise, the colour scheme is determined by
\code{milestone_palette_list$auto}.
\item \code{given}: The \code{milestones} object already contains a column \code{color}.
\item \code{cubeHelix}: Use the \code{rje::cubeHelix()} palette.
\item \code{Set3}: Use the \code{RColorBrewer::brewer.pal(name = "Set3")} palette.
\item \code{rainbow}: Use the \code{grDevices::rainbow()} palette.
}}

\item{milestones}{Tibble containing the column \code{milestone_id} (character).
If \code{color_milestones} is set to \code{"given"}, this tibble should also contain a column
\code{color} (character), containing colour hex codes (e.g. \code{"#123456"}).}

\item{milestone_percentages}{The milestone percentages.}
}
\value{
A named list with following objects:
\itemize{
\item cell_positions: The \code{trajectory$progressions} object with a \code{color} column added.
\item color_scale: A ggplot colour scale to add to the downstream ggplot.
\item fill_scale: A ggplot fill scale to add to the downstream ggplot.
\item color_cells: The input \code{color_cells} value, except \code{"auto"} will have been replaced depending
on which other parameters were passed.
}
}
\description{
The cells can be coloured by a grouping (clustering), according to a feature
(gene expression), closest milestone, or pseudotime from the root of the trajectory.
}
