% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evap.r
\name{approx.pe.ts}
\alias{approx.pe.ts}
\title{Create sinsuiodal time series of potential evapotranspiration input}
\usage{
approx.pe.ts(start, end, dt = 1, emin = 0, emax = 5/1000)
}
\arguments{
\item{start}{Start time of returned series in a format that can be coerced into a POSIXct instance. Defaults to start of rainfall data}

\item{end}{End time for returned series in a format that can be coerced into a POSIXct instance. Defaults to end of rainfall datA}

\item{dt}{Time interval in hours}

\item{emin}{Minimum daily PE total (m or mm)}

\item{emax}{Maximum daily PE total (m or mm)}
}
\value{
Time series (xts) of potential evapotranspiration ([L]/[T]) covering the given time range and at the desired interval in m or mm/hr
}
\description{
Create sinsuiodal time series of potential evapotranspiration input
}
\details{
Dynamic TOPMODEL requires a time series of potential
  evapotranspiration in order to calculate and remove actual
  evapotranpiration from the root zone during a run. Many sophisticated
  physical models have been developed for estimating PE and AE, including the
  Priestly-Taylor (Priestley and Taylor, 1972) and Penman-Monteith (Montieth,
  1965) methods. These, however, require detailed meterological data such as
  radiation input and relative humidities that are, in general, difficult to
  obtain. Calder (1983) demonstrated that a simple approximation using a
  sinusoidal variation in potential evapotranspiration to be a good
  approximation to more complex schemes.

  If the insolation is also taken to vary sinusoidally through the daylight
  hours then, ignoring diurnal meteorological variations, the potential
  evapotranspiration during daylight hours for each year day number can be
  calculated (for the catchment's latitude). Integration over the daylight
  hours allows the daily maximum to be calculated and thus a sub-daily series
  generated.
}
\examples{
\dontrun{
# Create PE data for 2012 for use in the Brompton test case

require(dynatopmodel)

data("brompton")

# Generate time series at hourly and 15 minute intervals
pe.60 <- approx.pe.ts("2012-01-01", "2012-12-31", dt=1)
pe.15 <- approx.pe.ts("2012-01-01", "2012-12-31", dt=0.25)

# Check annual totals - should be around 900mm
sum(pe.60)*1000
sum(pe.15*0.25)*1000

# Check maximum daily total on the 1st of July
sum(pe.60["2012-07-01"])*1000
sum(pe.15["2012-07-01"]*0.25)*1000
}
}
\references{
Beven, K. J. (2012). Rainfall-runoff modelling : the primer. Chichester, UK, Wiley-Blackwell.

Calder, I. R. (1986). A stochastic model of rainfall interception. Journal of Hydrology, 89(1), 65-71.
}

