/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.EOFException;
import java.io.IOException;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;
import org.freehep.graphicsio.swf.SoundInfo;

public class DefineButtonSound
extends DefinitionTag {
    private int character;
    private int[] soundID;
    private SoundInfo[] info;

    public DefineButtonSound(int id, int[] soundID, SoundInfo[] info) {
        this();
        this.character = id;
        this.soundID = soundID;
        this.info = info;
    }

    public DefineButtonSound() {
        super(17, 2);
    }

    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        DefineButtonSound tag = new DefineButtonSound();
        tag.character = swf.readUnsignedShort();
        swf.getDictionary().put(tag.character, tag);
        tag.soundID = new int[4];
        tag.info = new SoundInfo[4];
        try {
            for (int i = 0; i < 4; ++i) {
                tag.soundID[i] = swf.readUnsignedShort();
                tag.info[i] = new SoundInfo(swf);
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        return tag;
    }

    public void write(int tagID, SWFOutputStream swf) throws IOException {
        swf.writeUnsignedShort(this.character);
        for (int i = 0; i < 4; ++i) {
            swf.writeUnsignedShort(this.soundID[i]);
            if (this.info[i] != null) {
                this.info[i].write(swf);
                continue;
            }
            swf.writeUnsignedByte(0);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString() + "\n");
        s.append("  character:  " + this.character + "\n");
        for (int i = 0; i < this.soundID.length; ++i) {
            s.append("  ");
            s.append(this.soundID[i]);
            s.append(": ");
            s.append(this.info[i]);
            s.append("\n");
        }
        return s.toString();
    }
}

