/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.Random;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.test.TestingPanel;

public class TestCustomStrokes
extends TestingPanel {
    private Random random;
    private Stroke[] strokes = new Stroke[]{new BasicStroke(4.0f), new NullStroke(), new DoubleStroke(8.0f, 2.0f), new ControlPointsStroke(2.0f), new SloppyStroke(2.0f, 3.0f)};

    public TestCustomStrokes(String[] args) throws Exception {
        super(args);
        this.setName("Custom Strokes");
        this.random = new Random(123456L);
    }

    public void paintComponent(Graphics g) {
        int i;
        VectorGraphics vg = VectorGraphics.create((Graphics)g);
        Font f = new Font("Serif", 1, 150);
        GlyphVector gv = f.createGlyphVector(vg.getFontRenderContext(), "B");
        Shape shape = gv.getOutline();
        vg.setColor(Color.black);
        vg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        vg.translate(10, 175);
        for (i = 0; i < this.strokes.length; ++i) {
            vg.setStroke(this.strokes[i]);
            vg.draw(shape);
            vg.translate(100, 0);
        }
        vg.translate(-this.strokes.length * 100, 0);
        vg.translate(10, 100);
        for (i = 0; i < this.strokes.length; ++i) {
            vg.setStroke(this.strokes[i]);
            vg.drawRect(10, 10, 80, 50);
            vg.translate(100, 0);
        }
    }

    public static void main(String[] args) throws Exception {
        new TestCustomStrokes(args).runTest();
    }

    class SloppyStroke
    implements Stroke {
        BasicStroke stroke;
        float sloppiness;

        public SloppyStroke(float width, float sloppiness) {
            this.stroke = new BasicStroke(width);
            this.sloppiness = sloppiness;
        }

        public Shape createStrokedShape(Shape shape) {
            GeneralPath newshape = new GeneralPath();
            float[] coords = new float[6];
            PathIterator i = shape.getPathIterator(null);
            while (!i.isDone()) {
                int type = i.currentSegment(coords);
                switch (type) {
                    case 0: {
                        this.perturb(coords, 2);
                        newshape.moveTo(coords[0], coords[1]);
                        break;
                    }
                    case 1: {
                        this.perturb(coords, 2);
                        newshape.lineTo(coords[0], coords[1]);
                        break;
                    }
                    case 2: {
                        this.perturb(coords, 4);
                        newshape.quadTo(coords[0], coords[1], coords[2], coords[3]);
                        break;
                    }
                    case 3: {
                        this.perturb(coords, 6);
                        newshape.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                        break;
                    }
                    case 4: {
                        newshape.closePath();
                    }
                }
                i.next();
            }
            return this.stroke.createStrokedShape(newshape);
        }

        void perturb(float[] coords, int numCoords) {
            int i = 0;
            while (i < numCoords) {
                int n = i++;
                coords[n] = coords[n] + (float)((TestCustomStrokes.this.random.nextDouble() * 2.0 - 1.0) * (double)this.sloppiness);
            }
        }
    }

    class ControlPointsStroke
    implements Stroke {
        float radius;

        public ControlPointsStroke(float radius) {
            this.radius = radius;
        }

        public Shape createStrokedShape(Shape shape) {
            GeneralPath strokedShape = new GeneralPath(new BasicStroke(1.0f).createStrokedShape(shape));
            float[] coords = new float[6];
            PathIterator i = shape.getPathIterator(null);
            while (!i.isDone()) {
                int type = i.currentSegment(coords);
                switch (type) {
                    case 3: {
                        this.markPoint(strokedShape, coords[4], coords[5]);
                    }
                    case 2: {
                        this.markPoint(strokedShape, coords[2], coords[3]);
                    }
                    case 0: 
                    case 1: {
                        this.markPoint(strokedShape, coords[0], coords[1]);
                    }
                }
                i.next();
            }
            return strokedShape;
        }

        void markPoint(GeneralPath path, float x, float y) {
            path.moveTo(x - this.radius, y - this.radius);
            path.lineTo(x + this.radius, y - this.radius);
            path.lineTo(x + this.radius, y + this.radius);
            path.lineTo(x - this.radius, y + this.radius);
            path.closePath();
        }
    }

    class DoubleStroke
    implements Stroke {
        BasicStroke stroke1;
        BasicStroke stroke2;

        public DoubleStroke(float width1, float width2) {
            this.stroke1 = new BasicStroke(width1);
            this.stroke2 = new BasicStroke(width2);
        }

        public Shape createStrokedShape(Shape s) {
            Shape outline = this.stroke1.createStrokedShape(s);
            return this.stroke2.createStrokedShape(outline);
        }
    }

    class NullStroke
    implements Stroke {
        NullStroke() {
        }

        public Shape createStrokedShape(Shape s) {
            return s;
        }
    }
}

