/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;

public class SetStretchBltMode
extends EMFTag
implements EMFConstants {
    private int mode;

    public SetStretchBltMode() {
        super(21, 1);
    }

    public SetStretchBltMode(int mode) {
        this();
        this.mode = mode;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        return new SetStretchBltMode(emf.readDWORD());
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeDWORD(this.mode);
    }

    public String toString() {
        return super.toString() + "\n  mode: " + this.mode;
    }

    public void render(EMFRenderer renderer) {
        renderer.setScaleMode(this.getScaleMode(this.mode));
    }

    private int getScaleMode(int mode) {
        if (mode == 3) {
            return 2;
        }
        if (mode == 4) {
            return 4;
        }
        if (mode == 1) {
            return 8;
        }
        if (mode == 2) {
            return 8;
        }
        logger.warning("got unsupported SetStretchBltMode " + mode);
        return 1;
    }
}

