/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.util.BitSet;

public class EMFHandleManager {
    private BitSet handles = new BitSet();
    private int maxHandle;

    public int getHandle() {
        int handle = this.nextClearBit();
        this.handles.set(handle);
        if (handle > this.maxHandle) {
            this.maxHandle = handle;
        }
        return handle;
    }

    public int freeHandle(int handle) {
        this.handles.clear(handle);
        return handle;
    }

    private int nextClearBit() {
        int i = 1;
        while (this.handles.get(i)) {
            ++i;
        }
        return i;
    }

    public int highestHandleInUse() {
        return this.handles.length() - 1;
    }

    public int maxHandlesUsed() {
        return this.maxHandle + 1;
    }
}

