/*
 * Decompiled with CFR 0.152.
 */
package jas.util.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class ShadowBorder
extends AbstractBorder {
    public final int NORTHEAST = 1;
    public final int NORTHWEST = 2;
    public final int SOUTHEAST = 3;
    public final int SOUTHWEST = 4;
    private int size;
    private Color color;
    private int orientation;
    private static ShadowBorder defaultInstance = new ShadowBorder();

    public ShadowBorder() {
        this(null, 0, 5);
    }

    public ShadowBorder(Color c, int orientation, int size) {
        this.color = c;
        this.orientation = orientation;
        this.size = size;
    }

    public static ShadowBorder createShadowBorder() {
        return defaultInstance;
    }

    public void paintBorder(Component comp, Graphics g, int x, int y, int width, int height) {
        g.setColor(this.color == null ? comp.getBackground().darker() : this.color);
        switch (this.orientation) {
            case 2: {
                g.fillRect(x, y, width - this.size, this.size);
                g.fillRect(x, y, this.size, height - this.size);
            }
            case 1: {
                g.fillRect(x + this.size, y, width - this.size, this.size);
                g.fillRect(x + width - this.size, y, this.size, height - this.size);
            }
            case 4: {
                g.fillRect(x, y + height - this.size, width - this.size, this.size);
                g.fillRect(x, y + this.size, this.size, height - this.size);
            }
        }
        g.fillRect(x + this.size, y + height - this.size, width - this.size, this.size);
        g.fillRect(x + width - this.size, y + this.size, this.size, height - this.size);
    }

    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component c, Insets i) {
        switch (this.orientation) {
            case 2: {
                i.left = this.size;
                i.right = 0;
                i.top = this.size;
                i.bottom = 0;
                break;
            }
            case 1: {
                i.left = 0;
                i.right = this.size;
                i.top = this.size;
                i.bottom = 0;
                break;
            }
            case 4: {
                i.left = this.size;
                i.right = 0;
                i.top = 0;
                i.bottom = this.size;
                break;
            }
            default: {
                i.left = 0;
                i.right = this.size;
                i.top = 0;
                i.bottom = this.size;
            }
        }
        return i;
    }
}

