/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class UserProperties
extends Properties {
    private final String custFile = System.getProperty("user.home").concat(File.separator + "jas.properties");
    private static UserProperties theUserProperties;

    public UserProperties() {
        try {
            FileInputStream input = new FileInputStream(this.custFile);
            this.load(input);
            ((InputStream)input).close();
            if ((double)this.getFloat("property-version", 0.0f) < 0.9) {
                this.clear();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setFloat("property-version", 0.91f);
        theUserProperties = this;
    }

    protected UserProperties(Properties def) {
        super(def);
        theUserProperties = this;
    }

    public Rectangle getRectangle(String key, Rectangle def) {
        try {
            Rectangle result = new Rectangle();
            result.x = this.getInteger(key.concat("-x"));
            result.y = this.getInteger(key.concat("-y"));
            result.width = this.getInteger(key.concat("-w"));
            result.height = this.getInteger(key.concat("-h"));
            return result;
        }
        catch (Exception e) {
            return def;
        }
    }

    public void setRectangle(String key, Rectangle rect) {
        this.put(key.concat("-x"), String.valueOf(rect.x));
        this.put(key.concat("-y"), String.valueOf(rect.y));
        this.put(key.concat("-w"), String.valueOf(rect.width));
        this.put(key.concat("-h"), String.valueOf(rect.height));
    }

    public Color getColor(String key, Color def) {
        try {
            return new Color(this.getInteger(key.concat("-r")), this.getInteger(key.concat("-g")), this.getInteger(key.concat("-b")));
        }
        catch (Exception e) {
            return def;
        }
    }

    public void setColor(String key, Color c) {
        this.put(key.concat("-r"), String.valueOf(c.getRed()));
        this.put(key.concat("-g"), String.valueOf(c.getGreen()));
        this.put(key.concat("-b"), String.valueOf(c.getBlue()));
    }

    public String[] getStringArray(String key, String[] def) {
        try {
            String[] result = new String[this.getInteger(key + "-length")];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.getProperty(key + "-" + i);
            }
            return result;
        }
        catch (Exception e) {
            return def;
        }
    }

    public void setStringArray(String key, String[] sa) {
        if (sa == null) {
            sa = new String[]{};
        }
        this.put(key + "-length", String.valueOf(sa.length));
        for (int i = 0; i < sa.length; ++i) {
            this.put(key + "-" + i, sa[i]);
        }
    }

    public String getString(String key, String def) {
        try {
            String s = this.getProperty(key);
            return s == null ? def : s;
        }
        catch (Exception e) {
            return def;
        }
    }

    public void setString(String key, String s) {
        if (s == null) {
            s = "";
        }
        this.put(key, s);
    }

    public boolean getBoolean(String key, boolean def) {
        String value = this.getProperty(key);
        return value == null ? def : Boolean.valueOf(value);
    }

    public void setBoolean(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    public int getInteger(String key) throws NumberFormatException {
        return Integer.valueOf(this.getProperty(key));
    }

    public int getInteger(String key, int def) {
        try {
            return Integer.valueOf(this.getProperty(key));
        }
        catch (Exception e) {
            return def;
        }
    }

    public void setFloat(String key, float f) {
        this.put(key, String.valueOf(f));
    }

    public float getFloat(String key, float def) {
        try {
            return Float.valueOf(this.getProperty(key)).floatValue();
        }
        catch (Exception e) {
            return def;
        }
    }

    public void setInteger(String key, int i) {
        this.put(key, String.valueOf(i));
    }

    public void save() throws IOException {
        FileOutputStream output = new FileOutputStream(this.custFile);
        this.save(output, "Java Analysis Studio Custom Properties");
        ((OutputStream)output).close();
    }

    public static String[] updateStringArray(String[] oldArray, String newString) {
        return UserProperties.updateStringArray(oldArray, newString, 4);
    }

    public String[] updateStringArray(String[] oldArray, String newString, String lengthKey) {
        return UserProperties.updateStringArray(oldArray, newString, this.getInteger(lengthKey, 4));
    }

    public static String[] updateStringArray(String[] oldArray, String newString, int nStored) {
        if (newString == null) {
            return oldArray;
        }
        if (oldArray != null && oldArray.length > 0) {
            int i;
            if (oldArray[0].equals(newString)) {
                return oldArray;
            }
            for (i = 1; i < oldArray.length; ++i) {
                if (!oldArray[i].equals(newString)) continue;
                while (i > 0) {
                    oldArray[i] = oldArray[i - 1];
                    --i;
                }
                oldArray[0] = newString;
                return oldArray;
            }
            if (oldArray.length < nStored) {
                String[] result = new String[oldArray.length + 1];
                result[0] = newString;
                for (int i2 = 0; i2 < oldArray.length; ++i2) {
                    result[i2 + 1] = oldArray[i2];
                }
                return result;
            }
            for (i = nStored - 1; i > 0; --i) {
                oldArray[i] = oldArray[i - 1];
            }
            oldArray[0] = newString;
            return oldArray;
        }
        oldArray = new String[]{newString};
        return oldArray;
    }

    public static UserProperties getUserProperties() {
        return theUserProperties;
    }
}

