/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.ColorChooser;
import jas.util.ColorEvent;
import jas.util.ColorListener;
import jas.util.FieldBinding;
import jas.util.UnsupportedType;
import java.awt.Color;

class ColorFieldBinding
extends FieldBinding
implements ColorListener {
    private Color m_oldVal = Color.black;
    private ColorChooser m_field;

    ColorFieldBinding(ColorChooser field) {
        this.m_field = field;
        field.addColorListener(this);
    }

    void set(Object value) throws UnsupportedType {
        if (!(value instanceof Color)) {
            throw new UnsupportedType(this.m_field, value.getClass());
        }
        Color c = (Color)value;
        if (!this.m_oldVal.equals(c)) {
            this.m_field.setColor(c);
            this.m_oldVal = c;
        }
    }

    Object get(Class type) throws UnsupportedType {
        Color c = this.m_field.getColor();
        if (!type.isInstance(c)) {
            throw new UnsupportedType(this.m_field, type);
        }
        return c;
    }

    public void colorChanged(ColorEvent e) {
        Color c = this.m_field.getColor();
        if (c != this.m_oldVal) {
            this.setChanged();
        }
        this.notifyObservers();
    }

    protected void reset() {
        super.reset();
        this.m_oldVal = this.m_field.getColor();
    }
}

