/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.ScatterEnumeration;
import jas.hist.ScatterPlotSource;
import java.io.Serializable;
import java.util.Observable;

public class XML2DScatterDataSource
extends Observable
implements ScatterPlotSource,
Serializable {
    private double m_xmin;
    private double m_xmax;
    private double m_ymin;
    private double m_ymax;
    private int m_xAxisType;
    private int m_yAxisType;
    private String m_title;
    private double[][] m_data;

    public XML2DScatterDataSource(int p_xAxisType, int p_yAxisType, String p_title, double[][] p_data) {
        this.m_xAxisType = p_xAxisType;
        this.m_yAxisType = p_yAxisType;
        this.m_title = p_title;
        this.m_data = p_data;
        this.m_xmax = this.m_xmin = this.m_data[0][0];
        this.m_ymax = this.m_ymin = this.m_data[1][0];
        for (int i = 1; i < this.m_data[0].length; ++i) {
            if (this.m_data[0][i] < this.m_xmin) {
                this.m_xmin = this.m_data[0][i];
            }
            if (this.m_data[0][i] > this.m_xmax) {
                this.m_xmax = this.m_data[0][i];
            }
            if (this.m_data[1][i] < this.m_ymin) {
                this.m_ymin = this.m_data[1][i];
            }
            if (!(this.m_data[1][i] > this.m_ymax)) continue;
            this.m_ymax = this.m_data[1][i];
        }
    }

    public double getXMin() {
        return this.m_xmin;
    }

    public double getXMax() {
        return this.m_xmax;
    }

    public double getYMin() {
        return this.m_ymin;
    }

    public double getYMax() {
        return this.m_ymax;
    }

    public int getXAxisType() {
        return this.m_xAxisType;
    }

    public int getYAxisType() {
        return this.m_yAxisType;
    }

    public ScatterEnumeration startEnumeration(double xMin, double xMax, double yMin, double yMax) {
        return new FixedEnumeration(this.m_data, xMin, xMax, yMin, yMax);
    }

    public ScatterEnumeration startEnumeration() {
        return new FixedEnumeration(this.m_data);
    }

    public String getTitle() {
        return this.m_title;
    }

    private class FixedEnumeration
    implements ScatterEnumeration {
        private int pos = 0;
        private double[][] m_data;
        private boolean selectAll;
        private double m_xmin;
        private double m_xmax;
        private double m_ymin;
        private double m_ymax;

        public FixedEnumeration(double[][] p_data) {
            this.m_data = p_data;
            this.selectAll = true;
        }

        public FixedEnumeration(double[][] p_data, double xMin, double xMax, double yMin, double yMax) {
            this.m_data = p_data;
            this.selectAll = false;
            this.m_xmin = xMin;
            this.m_xmax = xMax;
            this.m_ymin = yMin;
            this.m_ymax = yMax;
        }

        public boolean getNextPoint(double[] a) {
            if (this.selectAll) {
                if (this.pos < this.m_data[0].length - 1) {
                    a[0] = this.m_data[0][this.pos];
                    a[1] = this.m_data[1][this.pos++];
                    return true;
                }
                return false;
            }
            while (!(this.m_data[0][this.pos] >= this.m_xmin && this.m_data[0][this.pos] <= this.m_xmax && this.m_data[1][this.pos] >= this.m_ymin && this.m_data[1][this.pos] <= this.m_ymax)) {
                ++this.pos;
                if (this.pos <= this.m_data[0].length - 1) continue;
                return false;
            }
            a[0] = this.m_data[0][this.pos];
            a[1] = this.m_data[1][this.pos++];
            return this.pos < this.m_data[0].length;
        }

        public void resetEndPoint() {
        }

        public void restart() {
            this.pos = 0;
        }
    }
}

