/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DateTransformationConverter;
import jas.hist.JASHist2DHistogramData;
import jas.hist.JASHist2DHistogramStyle;
import jas.hist.Rebinnable2DVariableHistogramData;
import jas.plot.ColorMap;
import jas.plot.ColorMapAxis;
import jas.plot.CoordinateTransformation;
import jas.plot.DateCoordinateTransformation;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.MutableLegendEntry;
import jas.plot.Overlay;
import jas.plot.OverlayContainer;
import jas.plot.PlotGraphics;
import jas.plot.Transformation;
import jas.plot.java2.PlotGraphics12;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Observable;
import java.util.Observer;

class TwoDOverlay
implements Overlay,
MutableLegendEntry,
Observer {
    protected OverlayContainer container;
    private Color color = Color.black;
    private JASHist2DHistogramData parent;
    private double[][] data;
    private double binHeightFixed;
    private double binWidthFixed;
    private double xHigh;
    private double xLow;
    private double yHigh;
    private double yLow;
    private double zlogmin;
    private double zmax;
    private double zmin;
    private int xBins;
    private int yBins;
    private ColorMapAxis colorMapAxis;
    private ColorMap colorMap;
    private boolean isColorMapAxisAdded = false;
    double cx;
    double cy;
    double cw;
    double ch;
    int c_mode;
    int s_mode;

    TwoDOverlay(JASHist2DHistogramData parent) {
        this.parent = parent;
        parent.style.addObserver(this);
        this.colorMap = new ColorMap(parent.style);
        this.colorMapAxis = new ColorMapAxis(this.colorMap);
        this.styleChanged(parent.style);
    }

    private void styleChanged(JASHist2DHistogramStyle style) {
        this.s_mode = style.getHistStyle();
        this.c_mode = style.getColorMapScheme();
        if (this.s_mode != 0 && this.s_mode != 1) {
            if (!this.isColorMapAxisAdded) {
                this.parent.parent.da.add(this.colorMapAxis, (Object)"yr");
            }
            this.isColorMapAxisAdded = true;
        } else if (this.isColorMapAxisAdded) {
            this.parent.parent.da.remove(this.colorMapAxis);
            this.isColorMapAxisAdded = false;
        }
    }

    public void update(Observable o, Object arg) {
        this.styleChanged((JASHist2DHistogramStyle)o);
    }

    public void setTitle(String newTitle) {
        this.parent.setLegendText(newTitle);
    }

    public String getTitle() {
        return this.parent.getLegendText();
    }

    public void containerNotify(OverlayContainer c) {
        this.container = c;
    }

    boolean isInClip(Transformation xt, Transformation yt, double x1, double y1, double x2, double y2) {
        double t;
        double xx1 = xt.convert(x1);
        double yy1 = yt.convert(y1);
        double xx2 = xt.convert(x2);
        double yy2 = yt.convert(y2);
        if (xx2 < xx1) {
            t = xx1;
            xx1 = xx2;
            xx2 = t;
        }
        if (yy2 < yy1) {
            t = yy1;
            yy1 = yy2;
            yy2 = t;
        }
        double w = xx2 - xx1 + 2.0;
        double h = yy2 - yy1 + 2.0;
        boolean ok = false;
        double dx = this.cx - xx1 + (this.cw - w) * 0.5;
        double dy = this.cy - yy1 + (this.ch - h) * 0.5;
        double dw = (this.cw + w) * 0.5;
        double dh = (this.ch + h) * 0.5;
        if (Math.abs(dx) <= dw && Math.abs(dy) <= dh) {
            ok = true;
        }
        return ok;
    }

    public void paint(PlotGraphics g, boolean isPrinting) {
        RenderingHints oldRh = null;
        if (g instanceof PlotGraphics12) {
            oldRh = ((PlotGraphics12)g).graphics().getRenderingHints();
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            ((PlotGraphics12)g).graphics().setRenderingHints(rh);
        }
        boolean doClipCheck = true;
        Rectangle rect = g.getClipBounds();
        if (rect == null) {
            doClipCheck = false;
        } else {
            this.cx = rect.x;
            this.cy = rect.y;
            this.cw = rect.width;
            this.ch = rect.height;
        }
        this.s_mode = this.parent.style.getHistStyle();
        this.c_mode = this.parent.style.getColorMapScheme();
        boolean log = this.parent.style.getLogZ();
        boolean uoState = false;
        boolean showZeroHeightBins = this.parent.style.getShowZeroHeightBins();
        if (this.data == null) {
            return;
        }
        int x_bins = this.xBins;
        int y_bins = this.yBins;
        CoordinateTransformation xp = this.container.getXTransformation();
        CoordinateTransformation yp = this.container.getYTransformation();
        if (xp instanceof DateCoordinateTransformation) {
            xp = new DateTransformationConverter((DateCoordinateTransformation)xp);
        }
        if (xp instanceof DoubleCoordinateTransformation && yp instanceof DoubleCoordinateTransformation) {
            double[] binXEdges = null;
            double[] binYEdges = null;
            if (this.parent.getDataSource() instanceof Rebinnable2DVariableHistogramData) {
                binXEdges = ((Rebinnable2DVariableHistogramData)this.parent.getDataSource()).getXBinEdges();
                binYEdges = ((Rebinnable2DVariableHistogramData)this.parent.getDataSource()).getYBinEdges();
            }
            DoubleCoordinateTransformation xt = (DoubleCoordinateTransformation)xp;
            DoubleCoordinateTransformation yt = (DoubleCoordinateTransformation)yp;
            g.setTransformation(xt, yt);
            if (this.s_mode == 0 || this.s_mode == 1) {
                g.setColor(Color.white);
            }
            if ((this.s_mode == 0 || this.s_mode == 1) && uoState) {
                g.setColor(Color.black);
                g.drawLine(xt.convert(this.xLow + this.binWidthFixed), yt.convert(this.yLow), xt.convert(this.xLow + this.binWidthFixed), yt.convert(this.yHigh));
                g.drawLine(xt.convert(this.xHigh - this.binWidthFixed), yt.convert(this.yLow), xt.convert(this.xHigh - this.binWidthFixed), yt.convert(this.yHigh));
                g.drawLine(xt.convert(this.xLow), yt.convert(this.yLow + this.binHeightFixed), xt.convert(this.xHigh), yt.convert(this.yLow + this.binHeightFixed));
                g.drawLine(xt.convert(this.xLow), yt.convert(this.yHigh - this.binHeightFixed), xt.convert(this.xHigh), yt.convert(this.yHigh - this.binHeightFixed));
            }
            double dispZmin = this.zmin;
            double dispZmax = this.zmax;
            if (log) {
                dispZmin = Math.log(this.zlogmin);
                dispZmax = Math.log(this.zmax);
            } else {
                if (dispZmin > 0.0 && dispZmax > 0.0) {
                    dispZmin = 0.0;
                }
                if (dispZmin < 0.0 && dispZmax < 0.0) {
                    dispZmax = 0.0;
                }
            }
            double zrange = dispZmax - dispZmin;
            if (zrange > 0.0) {
                if (this.s_mode == 0 || this.s_mode == 1) {
                    g.setColor(this.parent.style.getShapeColor());
                    double y = this.yLow;
                    for (int j = 0; j < y_bins; ++j) {
                        double binHeight = binYEdges == null ? this.binWidthFixed : binYEdges[j + 1] - binYEdges[j];
                        y += binHeight / 2.0;
                        double x = this.xLow;
                        for (int i = 0; i < x_bins; ++i) {
                            double binWidth = binXEdges == null ? this.binWidthFixed : binXEdges[i + 1] - binXEdges[i];
                            x += binWidth / 2.0;
                            double size = log ? Math.sqrt((Math.log(this.data[i][j]) - dispZmin) / zrange) : Math.sqrt((this.data[i][j] - dispZmin) / zrange);
                            double xFact = binWidth * size / 2.0;
                            double yFact = binHeight * size / 2.0;
                            if (size == 0.0) {
                                x += binWidth / 2.0;
                                continue;
                            }
                            double x1 = x - xFact;
                            double y1 = y - yFact;
                            double x2 = x + xFact;
                            double y2 = y + yFact;
                            if (doClipCheck && !this.isInClip(xt, yt, x1, y1, x2, y2)) continue;
                            if (this.s_mode == 0) {
                                g.drawRect(x1, y1, x2, y2);
                            } else {
                                g.drawOval(x1, y1, x2, y2);
                            }
                            x += binWidth / 2.0;
                        }
                        y += binHeight / 2.0;
                    }
                } else {
                    double oldY = this.yLow;
                    for (int j = 0; j < y_bins; ++j) {
                        double binHeight = binYEdges == null ? this.binWidthFixed : binYEdges[j + 1] - binYEdges[j];
                        double y = oldY + binHeight;
                        double oldX = this.xLow;
                        for (int i = 0; i < x_bins; ++i) {
                            double size;
                            double binWidth = binXEdges == null ? this.binWidthFixed : binXEdges[i + 1] - binXEdges[i];
                            double x = oldX + binWidth;
                            if (doClipCheck && !this.isInClip(xt, yt, oldX, oldY, x, y)) {
                                oldX = x;
                                continue;
                            }
                            double d = size = log ? (Math.log(this.data[i][j]) - dispZmin) / zrange : (this.data[i][j] - dispZmin) / zrange;
                            if ((showZeroHeightBins || size != 0.0) && size != Double.NEGATIVE_INFINITY) {
                                g.setColor(this.colorMap.getColor(size));
                                g.fillRect(oldX, oldY, x, y);
                            }
                            oldX = x;
                        }
                        oldY = y;
                    }
                }
            } else if (zrange == 0.0) {
                // empty if block
            }
        }
        if (oldRh != null) {
            ((PlotGraphics12)g).graphics().setRenderingHints(oldRh);
        }
    }

    public void paintIcon(PlotGraphics g, int width, int height) {
        g.setColor(this.parent.style.getShapeColor());
        g.fillRect(1.0, 1.0, width - 2, height - 2);
    }

    public boolean titleIsChanged() {
        return this.parent.isLegendChanged();
    }

    void setData(double[][] data, double xLow, double xHigh, double yLow, double yHigh, int xBins, int yBins) {
        this.data = data;
        this.xBins = xBins;
        this.yBins = yBins;
        this.xLow = xLow;
        this.xHigh = xHigh;
        this.yLow = yLow;
        this.yHigh = yHigh;
        this.binWidthFixed = (xHigh - xLow) / (double)xBins;
        this.binHeightFixed = (yHigh - yLow) / (double)yBins;
    }

    void setZMinMax(double zMin, double zMax, double zLogMin) {
        boolean log = this.parent.style.getLogZ();
        this.zmin = zMin;
        this.zlogmin = zLogMin;
        this.zmax = zMax;
        this.colorMapAxis.setZminZmax(this.zmin, this.zmax);
        this.colorMapAxis.setLogarithmic(log);
    }
}

