/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataManager;
import jas.hist.ExtendedStatistics;
import jas.hist.HasDataSource;
import jas.hist.HasScatterPlotData;
import jas.hist.HasStatistics;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist2DHistogramData;
import jas.hist.JASHist2DHistogramStyle;
import jas.hist.JASHistScatterPlotStyle;
import jas.hist.JASHistStyle;
import jas.hist.ScatterEnumeration;
import jas.hist.ScatterOverlay;
import jas.hist.Statistics;
import jas.hist.XMLPrintWriter;
import jas.plot.Overlay;
import jas.util.ColorConverter;
import jas.util.xml.HasXMLRepresentation;
import java.util.Observable;

class JASHist2DScatterData
extends JASHist2DHistogramData {
    HasScatterPlotData dataSource;
    boolean dataChanged;
    boolean resetSent;
    boolean onNewAxis;

    JASHist2DScatterData(DataManager dm, HasScatterPlotData ds) {
        super(dm, ds);
        this.dataSource = ds;
    }

    JASHistStyle createStyle() {
        return new JASHistScatterPlotStyle();
    }

    boolean hasScatterPlotData() {
        return this.dataSource.hasScatterPlotData();
    }

    public void setStyle(JASHistStyle style) {
        if (!(style instanceof JASHistScatterPlotStyle)) {
            throw new IllegalArgumentException("Style " + style.getClass() + " is not subclass of JASHistScatterPlotStyle");
        }
        if (this.style != null) {
            this.style.deleteObserver(this);
        }
        this.style = (JASHistScatterPlotStyle)style;
        this.style.addObserver(this);
    }

    Overlay createOverlay() {
        return new ScatterOverlay(this);
    }

    public void update(Observable o, Object arg) {
        if (o == this.dataSource) {
            this.parent.update((HistogramUpdate)arg, this);
        } else if (o == this.style) {
            this.parent.styleUpdate(this);
        }
    }

    void restartImage(boolean newEnumNeeded) {
        if (this.overlay instanceof ScatterOverlay) {
            ((ScatterOverlay)this.overlay).restartImage(newEnumNeeded);
        }
    }

    void continueImage() {
        if (this.overlay instanceof ScatterOverlay) {
            ((ScatterOverlay)this.overlay).continueImage();
        }
    }

    public JASHistStyle getStyle() {
        return this.style;
    }

    protected void calcZLimits() {
        if (((JASHistScatterPlotStyle)this.style).getDisplayAsScatterPlot()) {
            return;
        }
        super.calcZLimits();
    }

    public void writeAsXML(XMLPrintWriter pw, boolean snapshot) {
        String theXAxisType = XMLPrintWriter.convertAxisTypeToString(this.dataSource.getXAxisType());
        String theYAxisType = XMLPrintWriter.convertAxisTypeToString(this.dataSource.getYAxisType());
        pw.setAttribute("type", "scatter2d");
        pw.openTag("data2d");
        int xBins = this.dataSource.getXBins();
        double xLow = this.dataSource.getXMin();
        double xHigh = this.dataSource.getXMax();
        int yBins = this.dataSource.getYBins();
        double yLow = this.dataSource.getYMin();
        double yHigh = this.dataSource.getYMax();
        if (snapshot) {
            Statistics stats;
            double[][][] result = this.dataSource.rebin(xBins, xLow, xHigh, yBins, yLow, yHigh, true, this.hurry, this.style.getShowOverflow());
            if (result == null) {
                result = new double[1][xBins][yBins];
            }
            double[][] data = result[0];
            pw.setAttribute("title", this.getTitle());
            pw.setAttribute("dimensions", "2");
            pw.openTag("points");
            double[] d = new double[2];
            if (this.dataSource.hasScatterPlotData()) {
                ScatterEnumeration se = this.dataSource.startEnumeration();
                while (se.getNextPoint(d)) {
                    pw.println(d[0] + "," + d[1]);
                }
            }
            pw.closeTag();
            pw.printPointDataAxisAttributes("x", theXAxisType);
            pw.printPointDataAxisAttributes("y", theYAxisType);
            if (this.dataSource instanceof HasStatistics && (stats = ((HasStatistics)((Object)this.dataSource)).getStatistics()) != null) {
                pw.openTag("statistics");
                String[] names = stats.getStatisticNames();
                for (int i = 0; i < names.length; ++i) {
                    Object value;
                    String name = names[i];
                    pw.setAttribute("name", name);
                    String valueString = null;
                    if (stats instanceof ExtendedStatistics && (value = ((ExtendedStatistics)stats).getExtendedStatistic(name)) != null) {
                        valueString = value.toString();
                    }
                    if (valueString == null) {
                        valueString = String.valueOf(stats.getStatistic(name));
                    }
                    pw.setAttribute("value", valueString);
                    pw.printTag("statistic");
                }
                pw.closeTag();
            }
        } else if (this.dataSource instanceof HasXMLRepresentation) {
            ((HasXMLRepresentation)((Object)this.dataSource)).writeAsXML(pw);
        } else {
            if (this.dataSource instanceof HasDataSource) {
                pw.setAttribute("name", this.dataSource.getClass().getName());
            } else {
                pw.setAttribute("name", "???");
            }
            pw.setAttribute("param", "???");
            pw.printTag("class");
        }
        String histStyleName = JASHist2DHistogramStyle.getHistStyleName(this.style.getHistStyle());
        pw.setAttribute("histStyle", histStyleName);
        if (histStyleName.equals("STYLE_COLORMAP")) {
            pw.setAttribute("colorMapScheme", JASHist2DHistogramStyle.getColorMapSchemeName(this.style.getColorMapScheme()));
        }
        pw.setAttribute("shapeColor", ColorConverter.colorToString(this.style.getShapeColor()));
        pw.setAttribute("overflowBinColor", ColorConverter.colorToString(this.style.getOverflowBinColor()));
        pw.setAttribute("startDataColor", ColorConverter.colorToString(this.style.getStartDataColor()));
        pw.setAttribute("endDataColor", ColorConverter.colorToString(this.style.getEndDataColor()));
        pw.setAttribute("showOverflow", this.style.getShowOverflow());
        pw.setAttribute("showPlot", this.style.getShowPlot());
        pw.setAttribute("displayAsScatterPlot", ((JASHistScatterPlotStyle)this.style).getDisplayAsScatterPlot());
        pw.setAttribute("dataPointSize", ((JASHistScatterPlotStyle)this.style).getDataPointSize());
        pw.setAttribute("dataPointStyle", ((JASHistScatterPlotStyle)this.style).getDataPointStyle());
        pw.setAttribute("dataPointColor", ColorConverter.colorToString(((JASHistScatterPlotStyle)this.style).getDataPointColor()));
        pw.printTag("style2d");
        pw.closeTag();
    }
}

