/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.text;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import org.jvnet.lafwidget.LafWidgetAdapter;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetSupport;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.text.PasswordStrengthChecker;
import org.jvnet.lafwidget.utils.LafConstants;

public class PasswordStrengthCheckerWidget
extends LafWidgetAdapter {
    protected JPasswordField passwordField;
    protected PropertyChangeListener strengthCheckerListener;

    public void setComponent(JComponent jcomp) {
        super.setComponent(jcomp);
        this.passwordField = (JPasswordField)jcomp;
    }

    public void installListeners() {
        this.strengthCheckerListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("lafwidgets.passwordStrengthChecker".equals(evt.getPropertyName())) {
                    Object newValue = evt.getNewValue();
                    Object oldValue = evt.getOldValue();
                    if (newValue != null && newValue instanceof PasswordStrengthChecker && !(oldValue instanceof PasswordStrengthChecker)) {
                        PasswordStrengthCheckerWidget.this.passwordField.setBorder(new BorderUIResource.CompoundBorderUIResource(PasswordStrengthCheckerWidget.this.passwordField.getBorder(), new StrengthCheckedBorder()));
                    } else {
                        Border coreBorder = UIManager.getBorder("PasswordField.border");
                        PasswordStrengthCheckerWidget.this.passwordField.setBorder(coreBorder);
                        PasswordStrengthCheckerWidget.this.passwordField.setToolTipText(null);
                    }
                }
            }
        };
        this.passwordField.addPropertyChangeListener(this.strengthCheckerListener);
    }

    public void uninstallListeners() {
        this.passwordField.removePropertyChangeListener(this.strengthCheckerListener);
        this.strengthCheckerListener = null;
    }

    public void installDefaults() {
        super.installDefaults();
        Object checker = this.passwordField.getClientProperty("lafwidgets.passwordStrengthChecker");
        if (checker != null && checker instanceof PasswordStrengthChecker) {
            this.passwordField.setBorder(new BorderUIResource.CompoundBorderUIResource(this.passwordField.getBorder(), new StrengthCheckedBorder()));
        }
    }

    public boolean requiresCustomLafSupport() {
        return false;
    }

    private static class StrengthCheckedBorder
    implements Border {
        public static final int GUTTER_WIDTH = 5;

        private StrengthCheckedBorder() {
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Insets getBorderInsets(Component c) {
            JPasswordField jpf = (JPasswordField)c;
            if (LafWidgetUtilities.getPasswordStrengthChecker(jpf) == null) {
                return new Insets(0, 0, 0, 0);
            }
            if (c.getComponentOrientation().isLeftToRight()) {
                return new Insets(0, 0, 0, 5);
            }
            return new Insets(0, 5, 0, 0);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            JPasswordField jpf = (JPasswordField)c;
            PasswordStrengthChecker passwordStrengthChecker = LafWidgetUtilities.getPasswordStrengthChecker(jpf);
            if (passwordStrengthChecker == null) {
                return;
            }
            LafConstants.PasswordStrength strength = passwordStrengthChecker.getStrength(jpf.getPassword());
            LafWidgetSupport lafSupport = LafWidgetRepository.getRepository().getLafSupport();
            if (c.getComponentOrientation().isLeftToRight()) {
                lafSupport.paintPasswordStrengthMarker(g, x + width - 5, y, 5, height, strength);
            } else {
                lafSupport.paintPasswordStrengthMarker(g, x, y, 5, height, strength);
            }
            String tooltip = passwordStrengthChecker.getDescription(strength);
            jpf.setToolTipText(tooltip);
        }
    }
}

