/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.Values2D;

public abstract class DataUtilities {
    public static double calculateColumnTotal(Values2D data, int column) {
        double total = 0.0;
        int rowCount = data.getRowCount();
        int r = 0;
        while (r < rowCount) {
            Number n = data.getValue(r, column);
            if (n != null) {
                total += n.doubleValue();
            }
            ++r;
        }
        return total;
    }

    public static double calculateRowTotal(Values2D data, int row) {
        double total = 0.0;
        int columnCount = data.getColumnCount();
        int c = 0;
        while (c < columnCount) {
            Number n = data.getValue(row, c);
            if (n != null) {
                total += n.doubleValue();
            }
            ++c;
        }
        return total;
    }

    public static Number[] createNumberArray(double[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        Number[] result = new Number[data.length];
        int i = 0;
        while (i < data.length) {
            result[i] = new Double(data[i]);
            ++i;
        }
        return result;
    }

    public static Number[][] createNumberArray2D(double[][] data) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        int l1 = data.length;
        Number[][] result = new Number[l1][];
        int i = 0;
        while (i < l1) {
            result[i] = DataUtilities.createNumberArray(data[i]);
            ++i;
        }
        return result;
    }

    public static KeyedValues getCumulativePercentages(KeyedValues data) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        DefaultKeyedValues result = new DefaultKeyedValues();
        double total = 0.0;
        int i = 0;
        while (i < data.getItemCount()) {
            Number v = data.getValue(i);
            if (v != null) {
                total += v.doubleValue();
            }
            ++i;
        }
        double runningTotal = 0.0;
        int i2 = 0;
        while (i2 < data.getItemCount()) {
            Number v = data.getValue(i2);
            if (v != null) {
                runningTotal += v.doubleValue();
            }
            result.addValue(data.getKey(i2), new Double(runningTotal / total));
            ++i2;
        }
        return result;
    }
}

