/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.test.TestingPanel;

public class TestClip
extends TestingPanel {
    private Shape[] clip;
    private Shape[] path;

    public TestClip(String[] args) throws Exception {
        super(args);
        this.setName("Clip");
        this.clip = new Shape[6];
        this.clip[0] = new Rectangle2D.Double(1.0, 1.0, 6.0, 2.0);
        GeneralPath p = new GeneralPath();
        p.moveTo(1.0f, 1.0f);
        p.lineTo(1.0f, 3.0f);
        p.lineTo(7.0f, 3.0f);
        p.lineTo(7.0f, 1.0f);
        p.lineTo(5.0f, 1.0f);
        p.lineTo(4.0f, 3.0f);
        p.lineTo(3.0f, 1.0f);
        p.closePath();
        this.clip[1] = p;
        this.clip[2] = new Rectangle2D.Double(1.0, 1.0, 6.0, 2.0);
        this.clip[3] = new Rectangle2D.Double(1.0, 1.0, 6.0, 2.0);
        this.clip[4] = new Rectangle2D.Double(1.0, 1.0, 6.0, 2.0);
        this.clip[5] = new Ellipse2D.Double(1.0, 1.0, 6.0, 2.0);
        this.path = new Shape[6];
        p = new GeneralPath();
        p.moveTo(0.0f, 2.0f);
        p.lineTo(2.0f, 2.0f);
        p.lineTo(3.0f, 1.0f);
        p.lineTo(4.0f, 1.0f);
        p.lineTo(5.0f, 0.0f);
        p.lineTo(6.0f, 2.0f);
        p.lineTo(8.0f, 2.0f);
        p.lineTo(8.0f, 0.0f);
        p.lineTo(0.0f, 0.0f);
        p.closePath();
        this.path[0] = p;
        this.path[1] = new Rectangle2D.Double(0.0, 0.0, 8.0, 2.0);
        p = new GeneralPath();
        p.moveTo(0.0f, 2.0f);
        p.lineTo(2.0f, 2.0f);
        p.lineTo(3.0f, 1.0f);
        p.lineTo(5.0f, 1.0f);
        p.lineTo(6.0f, 2.0f);
        p.lineTo(8.0f, 2.0f);
        p.lineTo(8.0f, 0.0f);
        p.lineTo(0.0f, 0.0f);
        p.closePath();
        this.path[2] = p;
        this.path[3] = new Ellipse2D.Double(2.0, 0.0, 4.0, 4.0);
        p = new GeneralPath();
        p.moveTo(0.0f, 2.0f);
        p.lineTo(3.0f, 2.0f);
        p.lineTo(4.0f, 1.0f);
        p.lineTo(5.0f, 2.0f);
        p.lineTo(8.0f, 2.0f);
        p.lineTo(8.0f, 0.0f);
        p.lineTo(0.0f, 0.0f);
        p.closePath();
        this.path[4] = p;
        this.path[5] = new Ellipse2D.Double(2.0, 0.0, 4.0, 4.0);
    }

    public void paintComponent(Graphics g) {
        Area clippedPath;
        VectorGraphics svg2;
        int i;
        VectorGraphics vg = VectorGraphics.create((Graphics)g);
        Dimension dim = this.getSize();
        vg.setColor(Color.lightGray);
        vg.fillRect(0, 0, dim.width, dim.height);
        int nx = 6;
        int ny = 6;
        int dw = dim.width / (nx + 1);
        int dh = dim.height / ny;
        double factor = Math.min(dw, dh) / 10;
        vg.setColor(Color.black);
        VectorGraphics svg = (VectorGraphics)vg.create();
        svg.drawString("NoClip", 10, 20 + 0 * dh);
        svg.scale(factor, factor);
        svg.translate(10.0 / factor, 10.0 / factor + (double)(0 * dh) / factor);
        for (i = 0; i < nx; ++i) {
            svg.translate((double)dw / factor, 0.0);
            svg.setColor(Color.red);
            svg.setLineWidth(1.0 / factor);
            svg.draw(this.clip[i]);
            svg.setColor(Color.black);
            svg.setLineWidth(3.0 / factor);
            svg.draw(this.path[i]);
        }
        svg.dispose();
        svg = (VectorGraphics)vg.create();
        svg.drawString("JavaClip", 10, 20 + 1 * dh);
        svg.scale(factor, factor);
        svg.translate(10.0 / factor, 10.0 / factor + (double)(1 * dh) / factor);
        for (i = 0; i < nx; ++i) {
            svg.translate((double)dw / factor, 0.0);
            svg2 = (VectorGraphics)svg.create();
            svg2.setColor(Color.red);
            svg2.setLineWidth(1.0 / factor);
            svg2.draw(this.clip[i]);
            svg2.clip(this.clip[i]);
            svg2.setColor(Color.black);
            svg2.setLineWidth(3.0 / factor);
            svg2.draw(this.path[i]);
            svg2.dispose();
        }
        svg.dispose();
        svg = (VectorGraphics)vg.create();
        svg.drawString("OurClip", 10, 20 + 2 * dh);
        svg.scale(factor, factor);
        svg.translate(10.0 / factor, 10.0 / factor + (double)(2 * dh) / factor);
        for (i = 0; i < nx; ++i) {
            svg.translate((double)dw / factor, 0.0);
            svg2 = (VectorGraphics)svg.create();
            svg2.setColor(Color.red);
            svg2.setLineWidth(1.0 / factor);
            svg2.draw(this.clip[i]);
            svg2.setColor(Color.black);
            svg2.setLineWidth(3.0 / factor);
            clippedPath = new Area(this.clip[i]);
            clippedPath.intersect(new Area(this.path[i]));
            svg2.draw((Shape)clippedPath);
            svg2.dispose();
        }
        svg.dispose();
        svg = (VectorGraphics)vg.create();
        svg.drawString("NoClip", 10, 20 + 3 * dh);
        svg.scale(factor, factor);
        svg.translate(10.0 / factor, 10.0 / factor + (double)(3 * dh) / factor);
        for (i = 0; i < nx; ++i) {
            svg.translate((double)dw / factor, 0.0);
            svg.setColor(Color.red);
            svg.setLineWidth(1.0 / factor);
            svg.draw(this.clip[i]);
            svg.setColor(Color.black);
            svg.setLineWidth(3.0 / factor);
            svg.fill(this.path[i]);
        }
        svg.dispose();
        svg = (VectorGraphics)vg.create();
        svg.drawString("JavaClip", 10, 20 + 4 * dh);
        svg.scale(factor, factor);
        svg.translate(10.0 / factor, 10.0 / factor + (double)(4 * dh) / factor);
        for (i = 0; i < nx; ++i) {
            svg.translate((double)dw / factor, 0.0);
            svg2 = (VectorGraphics)svg.create();
            svg2.setColor(Color.red);
            svg2.setLineWidth(1.0 / factor);
            svg2.draw(this.clip[i]);
            svg2.clip(this.clip[i]);
            svg2.setColor(Color.black);
            svg2.setLineWidth(3.0 / factor);
            svg2.fill(this.path[i]);
            svg2.dispose();
        }
        svg.dispose();
        svg = (VectorGraphics)vg.create();
        svg.drawString("AreaClip", 10, 20 + 5 * dh);
        svg.scale(factor, factor);
        svg.translate(10.0 / factor, 10.0 / factor + (double)(5 * dh) / factor);
        for (i = 0; i < nx; ++i) {
            svg.translate((double)dw / factor, 0.0);
            svg2 = (VectorGraphics)svg.create();
            svg2.setColor(Color.red);
            svg2.setLineWidth(1.0 / factor);
            svg2.draw(this.clip[i]);
            svg2.setColor(Color.black);
            svg2.setLineWidth(3.0 / factor);
            clippedPath = new Area(this.clip[i]);
            clippedPath.intersect(new Area(this.path[i]));
            svg2.fill((Shape)clippedPath);
            svg2.dispose();
        }
        svg.dispose();
    }

    public static void main(String[] args) throws Exception {
        new TestClip(args).runTest();
    }
}

