/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.AbstractPolygon;

public class Polyline
extends AbstractPolygon {
    public Polyline() {
        super(4, 1, null, 0, null);
    }

    public Polyline(Rectangle bounds, int numberOfPoints, Point[] points) {
        super(4, 1, bounds, numberOfPoints, points);
    }

    protected Polyline(int id, int version, Rectangle bounds, int numberOfPoints, Point[] points) {
        super(id, version, bounds, numberOfPoints, points);
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        Rectangle r = emf.readRECTL();
        int n = emf.readDWORD();
        return new Polyline(r, n, emf.readPOINTL(n));
    }

    public void render(EMFRenderer renderer) {
        Point[] points = this.getPoints();
        int numberOfPoints = this.getNumberOfPoints();
        if (points != null && points.length > 0) {
            GeneralPath gp = new GeneralPath(renderer.getWindingRule());
            for (int point = 0; point < numberOfPoints; ++point) {
                Point p = points[point];
                if (point > 0) {
                    gp.lineTo((float)p.getX(), (float)p.getY());
                    continue;
                }
                gp.moveTo((float)p.getX(), (float)p.getY());
            }
            renderer.drawOrAppend(gp);
        }
    }
}

