/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;

public abstract class AbstractClipPath
extends EMFTag {
    private int mode;

    protected AbstractClipPath(int id, int version, int mode) {
        super(id, version);
        this.mode = mode;
    }

    public String toString() {
        return super.toString() + "\n  mode: " + this.mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void render(EMFRenderer renderer, Shape shape) {
        if (shape != null) {
            if (this.mode == 1) {
                renderer.clip(shape);
            } else if (this.mode == 5) {
                AffineTransform at = renderer.getTransform();
                renderer.resetTransformation();
                renderer.setClip(renderer.getInitialClip());
                renderer.setTransform(at);
                renderer.clip(shape);
            } else if (this.mode == 4) {
                Shape clip = renderer.getClip();
                if (clip != null) {
                    Area a = new Area(shape);
                    a.subtract(new Area(clip));
                    renderer.setClip(a);
                } else {
                    renderer.setClip(shape);
                }
            } else if (this.mode == 2) {
                GeneralPath path = new GeneralPath(shape);
                Shape clip = renderer.getClip();
                if (clip != null) {
                    path.append(clip, false);
                }
                renderer.setClip(path);
            } else if (this.mode == 3) {
                Shape clip = renderer.getClip();
                if (clip != null) {
                    Area a = new Area(shape);
                    a.exclusiveOr(new Area(clip));
                    renderer.setClip(a);
                } else {
                    renderer.setClip(shape);
                }
            }
        }
        renderer.setPath(null);
    }
}

