/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstancePaneBorder
extends AbstractBorder
implements UIResource {
    private static final int BORDER_THICKNESS = 4;
    private static final Insets INSETS = new Insets(4, 4, 4, 4);

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        ColorScheme colorScheme;
        Window window = SwingUtilities.getWindowAncestor(c);
        boolean isSelected = window == null ? true : window.isActive();
        ColorScheme colorScheme2 = colorScheme = isSelected ? SubstanceCoreUtilities.getActiveScheme((JComponent)c) : SubstanceCoreUtilities.getDefaultScheme((JComponent)c);
        if (isSelected && SubstanceLookAndFeel.getTheme() instanceof SubstanceComplexTheme) {
            colorScheme = ((SubstanceComplexTheme)SubstanceLookAndFeel.getTheme()).getActiveTitlePaneTheme().getColorScheme();
        }
        Graphics2D graphics = (Graphics2D)g;
        ColorScheme titleBarColorScheme = colorScheme;
        graphics.setColor(colorScheme.getUltraDarkColor());
        graphics.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        graphics.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        graphics.setColor(colorScheme.getDarkColor());
        graphics.drawLine(x, y, x + w - 2, y);
        graphics.drawLine(x, y, x, y + h - 2);
        graphics.setColor(colorScheme.getMidColor());
        graphics.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
        graphics.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
        graphics.setColor(colorScheme.getMidColor());
        graphics.drawLine(x + 1, y + 1, x + w - 3, y + 1);
        graphics.drawLine(x + 1, y + 1, x + 1, y + h - 3);
        if (colorScheme == titleBarColorScheme) {
            graphics.setColor(colorScheme.getLightColor());
        } else {
            graphics.setColor(titleBarColorScheme.getDarkColor());
        }
        graphics.drawRect(x + 2, y + 2, w - 5, h - 5);
        graphics.drawRect(x + 3, y + 3, w - 7, h - 7);
    }

    public Insets getBorderInsets(Component c) {
        return INSETS;
    }

    public Insets getBorderInsets(Component c, Insets newInsets) {
        newInsets.top = SubstancePaneBorder.INSETS.top;
        newInsets.left = SubstancePaneBorder.INSETS.left;
        newInsets.bottom = SubstancePaneBorder.INSETS.bottom;
        newInsets.right = SubstancePaneBorder.INSETS.right;
        return newInsets;
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

