/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.svg;

import java.awt.Shape;
import java.awt.font.GlyphMetrics;
import java.awt.geom.AffineTransform;
import org.freehep.graphicsio.svg.SVGGraphics2D;

public class SVGGlyph {
    public static int FONT_SIZE = 100;
    public static int UNITS_PER_EM = 2048;
    private Shape glyph;
    private int unicode;
    private GlyphMetrics glyphMetrics;
    private static AffineTransform defaultTransform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);

    public SVGGlyph(Shape glyph, int unicode, GlyphMetrics glyphMetrics) {
        this.unicode = unicode;
        this.glyph = glyph;
        this.glyphMetrics = glyphMetrics;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("<glyph ");
        result.append("unicode=\"");
        String hex = "0000" + Integer.toHexString(this.unicode);
        result.append("&#x");
        result.append(hex.substring(hex.length() - 4));
        result.append(';');
        result.append("\" ");
        if (this.glyphMetrics != null) {
            result.append(this.getHorizontalAdvanceXString());
            result.append(this.getHorizontalAdvanceYString());
        }
        result.append(this.getPathString());
        result.append("/>");
        return result.toString();
    }

    protected String getPathString() {
        return SVGGraphics2D.getPathContent(this.glyph.getPathIterator(defaultTransform));
    }

    public String getHorizontalAdvanceXString() {
        StringBuffer result = new StringBuffer();
        if (this.glyphMetrics.getAdvanceX() != 0.0f) {
            result.append("horiz-adv-x=\"");
            result.append(SVGGraphics2D.fixedPrecision(this.glyphMetrics.getAdvanceX()));
            result.append("\" ");
        }
        return result.toString();
    }

    public String getHorizontalAdvanceYString() {
        StringBuffer result = new StringBuffer();
        if (this.glyphMetrics.getAdvanceY() != 0.0f) {
            result.append("horiz-adv-y=\"");
            result.append(SVGGraphics2D.fixedPrecision(this.glyphMetrics.getAdvanceY()));
            result.append("\" ");
        }
        return result.toString();
    }
}

