/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;

public class ColorMenu
extends JMenu {
    private ColorSelectionModel colorModel;
    private ButtonGroup group = new ButtonGroup();
    public static final Color[] BASIC_COLORS = new Color[]{Color.black, Color.darkGray, Color.gray, Color.lightGray, Color.blue, Color.cyan, Color.green, Color.magenta, Color.red, Color.pink, Color.orange, Color.yellow, Color.white};
    public static final String[] BASIC_COLOR_NAMES = new String[]{"black", "dark gray", "gray", "light gray", "blue", "cyan", "green", "magenta", "red", "pink", "orange", "yellow", "white"};
    public static final Color[] EXTENDED_COLORS = new Color[]{Color.black, new Color(0.1f, 0.1f, 0.1f), new Color(0.2f, 0.2f, 0.2f), new Color(0.3f, 0.3f, 0.3f), new Color(0.4f, 0.4f, 0.4f), new Color(0.5f, 0.5f, 0.5f), new Color(0.6f, 0.6f, 0.6f), new Color(0.7f, 0.7f, 0.7f), new Color(0.8f, 0.8f, 0.8f), new Color(0.9f, 0.9f, 0.9f), Color.white, Color.red, new Color(255, 136, 28), new Color(120, 62, 27), new Color(0, 125, 32), new Color(11, 157, 150), Color.blue, new Color(109, 0, 168), new Color(168, 0, 126), Color.pink, Color.orange, Color.yellow, Color.green, Color.cyan, new Color(164, 207, 255), new Color(225, 170, 255), new Color(255, 170, 210)};
    public static final String[] EXTENDED_COLOR_NAMES = new String[]{"black", "grey 10%", "grey 20%", "grey 30%", "grey 40%", "grey 50%", "grey 60%", "grey 70%", "grey 80%", "grey 90%", "white", "red", "orange", "brown", "green", "turquoise", "blue", "purple", "magenta", "pink", "light orange", "yellow", "light green", "cyan", "sky blue", "violet", "light magenta"};
    private static final int size = 12;

    public ColorMenu(String name, ColorSelectionModel model) {
        this(name, model, false);
    }

    public ColorMenu(String name) {
        this(name, false);
    }

    public ColorMenu(String name, boolean extendedColors) {
        this(name, new DefaultColorSelectionModel(), extendedColors);
    }

    public ColorMenu(String name, ColorSelectionModel model, boolean extendedColors) {
        this(name, model, extendedColors ? EXTENDED_COLORS : BASIC_COLORS, extendedColors ? EXTENDED_COLOR_NAMES : BASIC_COLOR_NAMES);
    }

    public ColorMenu(String name, ColorSelectionModel model, Color[] colors, String[] names) {
        super(name);
        this.colorModel = model;
        for (int i = 0; i < colors.length; ++i) {
            this.add(new ColorMenuItem(colors[i], names[i]));
        }
        this.add(new OtherColorMenuItem());
    }

    public ColorSelectionModel getSelectionModel() {
        return this.colorModel;
    }

    public void setSelectionModel(ColorSelectionModel model) {
        this.colorModel = model;
    }

    public Color getColor() {
        return this.colorModel.getSelectedColor();
    }

    public void setColor(Color color) {
        this.colorModel.setSelectedColor(color);
    }

    protected void fireMenuSelected() {
        Color c = this.colorModel.getSelectedColor();
        Enumeration<AbstractButton> e = this.group.getElements();
        while (e.hasMoreElements()) {
            ColorMenuItem m = (ColorMenuItem)e.nextElement();
            m.setSelectedColor(c);
        }
        super.fireMenuSelected();
    }

    private class OtherColorMenuItem
    extends JMenuItem {
        OtherColorMenuItem() {
            super("Other...");
        }

        public void fireActionPerformed(ActionEvent e) {
            Color c = JColorChooser.showDialog(this, "Choose color...", ColorMenu.this.colorModel.getSelectedColor());
            if (c != null) {
                ColorMenu.this.colorModel.setSelectedColor(c);
            }
        }
    }

    private class ColorMenuItem
    extends JRadioButtonMenuItem
    implements Icon {
        private Color color;

        ColorMenuItem(Color c, String s) {
            super(s);
            this.setIcon(this);
            this.color = c;
            ColorMenu.this.group.add(this);
        }

        public void fireActionPerformed(ActionEvent e) {
            ColorMenu.this.colorModel.setSelectedColor(this.color);
        }

        void setSelectedColor(Color c) {
            this.setSelected(c == this.color);
        }

        public int getIconHeight() {
            return 12;
        }

        public int getIconWidth() {
            return 12;
        }

        public void paintIcon(Component p1, Graphics g, int x, int y) {
            Color save = g.getColor();
            g.setColor(this.color == null ? this.getBackground() : this.color);
            g.fill3DRect(x, y, 12, 12, true);
            g.setColor(save);
        }
    }
}

