/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.EditableLabel;
import jas.plot.FontMenuItem;
import jas.plot.LegendEntry;
import jas.plot.LegendLayout;
import jas.plot.MovableObject;
import jas.plot.MutableLegendEntry;
import jas.plot.SetablePlotGraphics;
import jas.plot.java2.PlotGraphics12;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;

public class Legend
extends MovableObject {
    private SetablePlotGraphics pg = new PlotGraphics12();
    private static final Dimension preferredIconSize = new Dimension(15, 15);

    public Legend() {
        super("Legend");
        this.setLayout(new LegendLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    public void add(final LegendEntry e) {
        super.add(new LegendComponent(e));
        EditableLabel label = new EditableLabel(e.getTitle(), "Legend Entry", 2){

            protected void fireActionPerformed() {
                super.fireActionPerformed();
                if (e instanceof MutableLegendEntry) {
                    ((MutableLegendEntry)e).setTitle(this.getText());
                }
            }
        };
        label.setShowFontMenuItem(false);
        super.add(label);
    }

    public void remove(LegendEntry e) {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = this.getComponent(i);
            if (!(c instanceof LegendComponent) || ((LegendComponent)c).le != e) continue;
            this.remove(i);
            this.remove(i);
            return;
        }
    }

    public void clear() {
        this.removeAll();
    }

    public int getNEntries() {
        return this.getComponentCount() / 2;
    }

    public String getCurrentTitle(int index) {
        LegendEntry le = ((LegendComponent)this.getComponent((int)(2 * index))).le;
        return le.getTitle();
    }

    public boolean isTitleChanged(int index) {
        LegendEntry le = ((LegendComponent)this.getComponent((int)(2 * index))).le;
        if (le instanceof MutableLegendEntry) {
            return ((MutableLegendEntry)le).titleIsChanged();
        }
        return false;
    }

    public void setCurrentTitle(int index, String title) {
        LegendEntry le = ((LegendComponent)this.getComponent((int)(2 * index))).le;
        if (le instanceof MutableLegendEntry) {
            ((MutableLegendEntry)le).setTitle(title);
        }
    }

    public void modifyPopupMenu(JPopupMenu menu, Component source) {
        if (menu.getComponentCount() > 0) {
            menu.addSeparator();
        }
        menu.add(new FontMenuItem(this, this.getPrefix()));
        super.modifyPopupMenu(menu, source);
    }

    public void setFont(Font font) {
        super.setFont(font);
        int n = this.getComponentCount();
        for (int i = 1; i < n; i += 2) {
            this.getComponent(i).setFont(font);
        }
    }

    public void legendTextChanged() {
        int n = this.getComponentCount();
        int i = 0;
        while (i < n) {
            LegendComponent c = (LegendComponent)this.getComponent(i++);
            EditableLabel el = (EditableLabel)this.getComponent(i++);
            el.setText(c.le.getTitle());
        }
    }

    private class LegendComponent
    extends Component {
        LegendEntry le;

        LegendComponent(LegendEntry e) {
            this.le = e;
        }

        public void paint(Graphics g) {
            Dimension d = this.getSize();
            Legend.this.pg.setGraphics(g);
            this.le.paintIcon(Legend.this.pg, d.width, d.height);
        }

        public Dimension getPreferredSize() {
            return preferredIconSize;
        }
    }
}

