/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.DataArea;
import jas.plot.Legend;
import jas.plot.TextBlock;
import jas.plot.Title;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;

public class ChartLayout
implements LayoutManager2 {
    private Legend legend;
    private DataArea data;
    private Title title;
    private TextBlock stats;
    private static final int pad = 5;

    public void addLayoutComponent(Component c, Object constraints) {
        if (c instanceof Title) {
            this.title = (Title)c;
        }
        if (c instanceof DataArea) {
            this.data = (DataArea)c;
        }
        if (c instanceof Legend) {
            this.legend = (Legend)c;
        }
        if (c instanceof TextBlock) {
            this.stats = (TextBlock)c;
        }
    }

    public void addLayoutComponent(String s, Component c) {
        this.addLayoutComponent(c, s);
    }

    public void removeLayoutComponent(Component c) {
        if (c == this.title) {
            this.title = null;
        }
        if (c == this.data) {
            this.data = null;
        }
        if (c == this.legend) {
            this.legend = null;
        }
        if (c == this.stats) {
            this.stats = null;
        }
    }

    public void layoutContainer(Container parent) {
        Dimension parentSize = parent.getSize();
        int titleOffset = 0;
        if (this.title != null && this.title.isVisible()) {
            Dimension size = this.title.getPreferredSize();
            if (!this.title.hasBeenResized()) {
                this.title.setSize(parentSize.width - 5 - 5, size.height);
            }
            if (!this.title.hasBeenMoved()) {
                this.title.setLocation(5, 5);
            }
            titleOffset += size.height;
        }
        if (this.data != null) {
            if (!this.data.hasBeenResized()) {
                this.data.setSize(parentSize.width - 5 - 5, parentSize.height - 5 - 5 - titleOffset);
            }
            if (!this.data.hasBeenMoved()) {
                this.data.setLocation(5, 5 + titleOffset);
            }
        }
        if (this.legend != null && this.legend.isVisible()) {
            Dimension ls = this.legend.getPreferredSize();
            if (!this.legend.hasBeenMoved()) {
                this.legend.setLocation(parentSize.width - 5 - ls.width, 5 + titleOffset);
            }
            if (!this.legend.hasBeenResized()) {
                this.legend.setSize(ls);
            }
            titleOffset += ls.height + 5;
        }
        if (this.stats != null && this.stats.isVisible()) {
            Dimension ss = this.stats.getPreferredSize();
            if (!this.stats.hasBeenMoved()) {
                this.stats.setLocation(parentSize.width - 5 - ss.width, 5 + titleOffset);
            }
            if (!this.stats.hasBeenResized()) {
                this.stats.setSize(ss);
            }
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension maximumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.title != null ? this.title.getPreferredSize() : new Dimension(10, 10);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    void restoreDefaultLayout() {
        if (this.legend != null) {
            this.legend.restoreDefaultLayout();
        }
        if (this.title != null) {
            this.title.restoreDefaultLayout();
        }
        if (this.stats != null) {
            this.stats.restoreDefaultLayout();
        }
        if (this.data != null) {
            this.data.restoreDefaultLayout();
        }
    }

    boolean hasDefaultLayout() {
        boolean result = true;
        if (this.legend != null) {
            result &= this.legend.hasDefaultLayout();
        }
        if (this.title != null) {
            result &= this.title.hasDefaultLayout();
        }
        if (this.stats != null) {
            result &= this.stats.hasDefaultLayout();
        }
        if (this.data != null) {
            result &= this.data.hasDefaultLayout();
        }
        return result;
    }
}

