/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataSource;
import jas.util.xml.XMLNodeTraverser;
import java.awt.Color;
import java.lang.reflect.Constructor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class ConstructorNodeTraverser
extends XMLNodeTraverser {
    protected Object ds;
    private String className;
    private String[] values;
    private String[] types;
    private int vc = 0;
    private int tc = 0;

    ConstructorNodeTraverser(Node node) throws XMLNodeTraverser.BadXMLException {
        int maxSize = node.getChildNodes().getLength();
        this.types = new String[maxSize];
        this.values = new String[maxSize];
        this.traverse(node);
        try {
            Class<?> c = null;
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            c = ccl != null ? ccl.loadClass(this.className) : Class.forName(this.className);
            if (this.vc == 0) {
                this.ds = c.newInstance();
            } else {
                Class[] argc = new Class[this.vc];
                Object[] args = new Object[this.vc];
                for (int i = 0; i < this.vc; ++i) {
                    argc[i] = this.toClass(this.types[i]);
                    args[i] = this.toObject(this.values[i], this.types[i]);
                }
                Constructor<?> con = c.getConstructor(argc);
                this.ds = con.newInstance(args);
            }
        }
        catch (Throwable t) {
            throw new XMLNodeTraverser.BadXMLException("Error instantiating class " + this.className + ": " + t);
        }
    }

    protected void handleElement(Element node, String name) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("param")) {
            this.traverse(node);
        } else {
            super.handleElement(node, name);
        }
    }

    protected void handleAttributeNode(Attr node, String name, String value) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("name")) {
            this.className = value;
        } else if (name.equals("type")) {
            this.types[this.tc++] = value;
        } else if (name.equals("value")) {
            this.values[this.vc++] = value;
        } else {
            super.handleAttributeNode(node, name, value);
        }
    }

    private Class toClass(String type) throws XMLNodeTraverser.BadXMLException {
        if (type.equals("int")) {
            return Integer.TYPE;
        }
        if (type.equals("double")) {
            return Double.TYPE;
        }
        if (type.equals("Color")) {
            return Color.class;
        }
        if (type.equals("String")) {
            return String.class;
        }
        throw new XMLNodeTraverser.BadXMLException("Unknown type " + type);
    }

    private Object toObject(String value, String type) throws XMLNodeTraverser.BadXMLException {
        try {
            if (type.equals("int")) {
                return new Integer(value);
            }
            if (type.equals("double")) {
                return new Double(value);
            }
            if (type.equals("Color")) {
                return this.toColor(value);
            }
            if (type.equals("String")) {
                return value;
            }
            throw new XMLNodeTraverser.BadXMLException("Unknown type " + type);
        }
        catch (XMLNodeTraverser.BadXMLException x) {
            throw x;
        }
        catch (Throwable t) {
            throw new XMLNodeTraverser.BadXMLException("Error converting parameter " + value + " to " + type);
        }
    }

    abstract DataSource getDataSource();
}

