/*
 * Decompiled with CFR 0.152.
 */
package dyn;

import don.Continue;
import don.DonneeID;
import don.Individu;
import don.IndividuMoyen;
import don.Modalite;
import drawing.Series;
import dyn.NuagePointHabille;
import ihm.Gestionnaire;
import ihm.Habilleur;
import java.util.Iterator;
import java.util.Vector;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.xy.XYBubbleRendererDynGraph;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;

public class Bubble
extends NuagePointHabille {
    public Bubble(Gestionnaire gest, Habilleur hab, String titreGraphe, String titreX, String titreY) {
        super(gest, hab, titreGraphe, titreX, titreY);
    }

    protected JFreeChart createChart(XYDataset dataset) {
        if (dataset instanceof XYZDataset) {
            JFreeChart chart = ChartFactory.createBubbleChart(this.getTitreGraphe(), this.getTitreX(), this.getTitreY(), (XYZDataset)dataset, this.getOrientation(), this.m_gestionnaire.isAffLegende(), false, false, new XYBubbleRendererDynGraph());
            return chart;
        }
        return null;
    }

    protected XYDataset construireSeries() {
        double[][] don;
        this.setCanvas();
        this.m_data = new DefaultXYZDataset();
        Iterator ite = this.getDonnee().iterator();
        Vector<Series> partiels = new Vector<Series>();
        int taille = 0;
        while (ite.hasNext()) {
            Series s = (Series)ite.next();
            String cde = s.getSemantique();
            don = new double[3][s.getNbDonneeID()];
            int i = 0;
            int nb = 0;
            while (i < s.getNbDonneeID()) {
                DonneeID donneeID = s.getDonneeID(i);
                if (!this.m_gestionnaire.isFantome(donneeID)) {
                    don[0][nb] = donneeID.getCoord(this.m_gestionnaire.getAxeX());
                    don[1][nb] = donneeID.getCoord(this.m_gestionnaire.getAxeY());
                    this.m_canvas.addPoint(donneeID);
                    if (donneeID instanceof IndividuMoyen && this.m_gestionnaire.isAffPartiels(donneeID)) {
                        Series part = new Series();
                        IndividuMoyen ind = (IndividuMoyen)donneeID;
                        int j = 0;
                        while (j < ind.getNbBranches()) {
                            part.addDonneeID(ind.getBranches().get(j));
                            ++taille;
                            ++j;
                        }
                        partiels.add(part);
                    }
                    if (donneeID instanceof Individu) {
                        Continue habillageInd = this.m_habilleur.getHabillageContinu(0);
                        don[2][nb] = habillageInd != null && this.m_habilleur.getHabillageStyleContinu(0) == 0 ? this.m_habilleur.getZ(donneeID, habillageInd) : 0.05;
                    } else if (donneeID instanceof Modalite) {
                        Continue habillageMod = this.m_habilleur.getHabillageContinu(1);
                        don[2][nb] = habillageMod != null && this.m_habilleur.getHabillageStyleContinu(1) == 0 ? this.m_habilleur.getZ(donneeID, habillageMod) : 0.05;
                    }
                    ++nb;
                }
                ++i;
            }
            double[][] donF = new double[3][nb];
            int j = 0;
            while (j < nb) {
                donF[0][j] = don[0][j];
                donF[1][j] = don[1][j];
                donF[2][j] = don[2][j];
                ++j;
            }
            if (i == 0) continue;
            ((DefaultXYZDataset)this.m_data).addSeries((Comparable)((Object)cde), donF);
        }
        don = new double[3][taille];
        int cpt = 0;
        int i = 0;
        while (i < partiels.size()) {
            this.m_partiel = true;
            int j = 0;
            while (j < ((Series)partiels.get(i)).getNbDonneeID()) {
                don[0][cpt] = ((Series)partiels.get(i)).getDonneeID(j).getCoord(this.m_gestionnaire.getAxeX());
                don[1][cpt] = ((Series)partiels.get(i)).getDonneeID(j).getCoord(this.m_gestionnaire.getAxeY());
                don[2][cpt] = 0.0;
                this.m_canvas.addPoint(((Series)partiels.get(i)).getDonneeID(j));
                ++cpt;
                ++j;
            }
            ++i;
        }
        if (partiels.size() != 0) {
            ((DefaultXYZDataset)this.m_data).addSeries((Comparable)((Object)"partiel"), don);
        }
        return this.m_data;
    }
}

