/*
 * Decompiled with CFR 0.152.
 */
package don;

import don.Groupe;
import don.IndividuMoyen;
import don.Modalite;
import don.Nominale;
import don.Partitionnable;
import ihm.FenetreErreur;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Individu
extends Partitionnable {
    private static final long serialVersionUID = -5138037164711285332L;
    private IndividuMoyen m_pere;
    private double[] m_coordContinues;
    private HashMap<Nominale, Modalite> m_modalites;

    public Individu(String annotation, boolean active, Groupe gr, double[] coord, double[] cos2, double[] contrib, double[] coordContinues) {
        super(annotation, active, gr, coord, cos2, contrib, 0);
        this.m_coordContinues = coordContinues;
        this.m_modalites = new HashMap();
    }

    public double[] getCoordContinues() {
        return this.m_coordContinues;
    }

    public double getValeur(int i) {
        return this.m_coordContinues[i];
    }

    public void setCoordContinues(double[] z) {
        this.m_coordContinues = z;
    }

    public Vector<Modalite> getModalites() {
        return new Vector<Modalite>(this.m_modalites.values());
    }

    public Modalite getModalite(Nominale nominale) {
        return this.m_modalites.get(nominale);
    }

    public void addModalite(Modalite mod) {
        if (mod == null) {
            new FenetreErreur("modalit\u00e9 nulle !");
        } else {
            if (this.m_modalites.containsKey(mod.getNominale())) {
                this.m_modalites.remove(mod.getNominale());
            }
            this.m_modalites.put(mod.getNominale(), mod);
            if (mod.getNbIndividus() == 0 || !mod.getIndividus().contains(this)) {
                mod.addIndividu(this);
            }
        }
    }

    public IndividuMoyen getPere() {
        return this.m_pere;
    }

    public void setPere(IndividuMoyen pere) {
        this.m_pere = pere;
        if (pere.getBranches() == null || !pere.getBranches().contains(this)) {
            pere.addBranche(this);
        }
        this.setGeneration(pere.getGeneration() + 1);
    }

    @Override
    public String toString() {
        String chaine = super.toString();
        chaine = String.valueOf(chaine) + "\nvaleurs quanti : ";
        int i = 0;
        while (i < this.m_coordContinues.length) {
            chaine = String.valueOf(chaine) + this.m_coordContinues[i] + "|| ";
            ++i;
        }
        chaine = String.valueOf(chaine) + "\nmodalit\u00e9s :";
        for (Modalite mod : this.m_modalites.values()) {
            chaine = mod != null ? String.valueOf(chaine) + "\n" + mod.getNominale().getAnnotation() + " : " + mod.getAnnotation() : String.valueOf(chaine) + "\nmodalit\u00e9 nulle";
        }
        return chaine;
    }
}

