/*
 * Decompiled with CFR 0.152.
 */
package criteres;

import criteres.Critere;
import criteres.CritereActif;
import criteres.CritereCompose;
import criteres.CritereTypeDeDonnee;
import criteres.Info;
import criteres.Paire;
import criteres.Singleton;
import don.DonneeID;
import don.Individu;
import ihm.IHM;
import java.io.File;

public class CritereAjout
extends CritereCompose {
    public CritereAjout(Critere critere1, Critere critere2) {
        super(critere1, critere2);
    }

    public void addCritere(Critere critere) {
        this.m_critere1 = this.m_critere1 == null ? critere : new CritereCompose(this.m_critere1, critere);
    }

    public Info evaluer(DonneeID obj) {
        Info val1 = this.m_critere1.evaluer(obj);
        Info val2 = this.m_critere2.evaluer(obj);
        if (val1.isError() && val2.isError()) {
            return new Singleton(Integer.MAX_VALUE);
        }
        if (val2.isError()) {
            return new Paire(val1, (Info)new Singleton(Integer.MAX_VALUE));
        }
        return new Paire(new Singleton(Integer.MAX_VALUE), val2);
    }

    public int getNbSeries() {
        int nb = 0;
        if (this.m_critere1 != null) {
            nb += this.m_critere1.getNbSeries();
        }
        if (this.m_critere2 != null) {
            nb += this.m_critere2.getNbSeries();
        }
        return nb;
    }

    public String semantique() {
        return "(" + this.m_critere1.semantique() + " + " + this.m_critere2.semantique() + ")";
    }

    public String semantique(Paire i) {
        Info g = i.getG();
        Info d = i.getD();
        if (g.isError() && d.isError()) {
            return "erreur (critere) ajout (paire d'erreurs)";
        }
        if (g.isError()) {
            return this.m_critere2.semantique(d);
        }
        if (d.isError()) {
            return this.m_critere1.semantique(g);
        }
        return "erreur (critere) ajout (paire sans erreur)";
    }

    public String semantique(Singleton i) {
        return "erreur (critere) ajout (singleton)";
    }

    public String semantique(Info i) {
        if (i instanceof Paire) {
            return this.semantique((Paire)i);
        }
        if (i instanceof Singleton) {
            return this.semantique((Singleton)i);
        }
        return "erreur (critere) ajout (type impossible)";
    }

    public static void main(String[] args) {
        IHM.m_dir = String.valueOf(new File("").getAbsolutePath()) + "\\";
        Individu ind = new Individu("ind", false, null, null, null, null, null);
        ind.setGeneration(3);
        CritereTypeDeDonnee c3 = new CritereTypeDeDonnee();
        System.out.println(c3.qualifier(ind));
        CritereActif c1 = new CritereActif();
        System.out.println(((Critere)c1).qualifier(ind));
        CritereAjout crit = new CritereAjout(c3, c1);
        System.out.println(crit.qualifier(ind));
        System.out.println("-----------------");
        Individu ind2 = new Individu("ind2", true, null, null, null, null, null);
        ind.setGeneration(3);
        System.out.println(c3.qualifier(ind2));
        System.out.println(((Critere)c1).qualifier(ind2));
        System.out.println(crit.qualifier(ind2));
    }
}

