/*
 * Decompiled with CFR 0.152.
 */
package criteres;

import criteres.Info;
import criteres.Paire;
import criteres.Singleton;
import criteres.Test;
import don.DonneeID;

public abstract class Critere {
    public static final String CHAINE_ERREUR = "erreur (critere)";
    public static final int CODE_ERROR = Integer.MAX_VALUE;
    public static final int CODE_OK = 0;

    public abstract int getNbSeries();

    public abstract Info evaluer(DonneeID var1);

    public Test not() {
        final Critere pere = this;
        return new Test(){

            public boolean correspond(DonneeID obj) {
                return pere.evaluer(obj).isError();
            }

            public String semantique() {
                return "";
            }

            public boolean adjectif() {
                return pere.adjectif();
            }

            public int compare(Info i0, Info i1) {
                return -pere.compare(i0, i1);
            }
        };
    }

    public Test test() {
        final Critere pere = this;
        return new Test(){

            public boolean correspond(DonneeID obj) {
                return !pere.evaluer(obj).isError();
            }

            public String semantique() {
                return "";
            }

            public boolean adjectif() {
                return pere.adjectif();
            }

            public int compare(Info i0, Info i1) {
                return pere.compare(i0, i1);
            }
        };
    }

    public abstract String semantique();

    public String semantique(Paire i) {
        return "erreur (critere) de base";
    }

    public String semantique(Info i) {
        if (i instanceof Paire) {
            return this.semantique((Paire)i);
        }
        return this.semantique((Singleton)i);
    }

    public abstract String semantique(Singleton var1);

    public String qualifier(DonneeID obj) {
        Info res = this.evaluer(obj);
        if (res instanceof Paire) {
            return this.semantique((Paire)res);
        }
        return this.semantique((Singleton)res);
    }

    public abstract boolean adjectif();

    protected int compare(Paire i0, Paire i1) {
        return 0;
    }

    protected int compare(Singleton i0, Singleton i1) {
        return i0.get() - i1.get();
    }

    public int compare(Info g0, Info g1) {
        if (g0 instanceof Paire && g1 instanceof Paire) {
            return this.compare((Paire)g0, (Paire)g1);
        }
        if (g0 instanceof Singleton && g1 instanceof Singleton) {
            return this.compare((Singleton)g0, (Singleton)g1);
        }
        return 0;
    }
}

