% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append_to_stream.R
\name{append_record_to_stream}
\alias{append_record_to_stream}
\title{Append a record, consisting of a list of depth one, to a stream.}
\usage{
append_record_to_stream(owner_id, dataset_id, stream_id, record,
  retry_times = 3, retry_quiet = FALSE)
}
\arguments{
\item{owner_id}{User name and unique identifier of the creator of a
dataset or project}

\item{dataset_id}{Dataset unique identifier}

\item{stream_id}{Stream unique identifier as defined by the user the first
time the stream was used. Only lower case letters, numbers and
dashes are allowed.}

\item{record}{the record list}

\item{retry_times}{the number of times to retry the request}

\item{retry_quiet}{whether to suppress diagnostic messages during retries}
}
\value{
Server response message.
}
\description{
Append a record, consisting of a list of depth one, to a stream.
The list
must consist of atomic vectors of length one.  If the data.world API
returns an HTTP status of 429 (Too Many Requests), this function uses
\code{\link[httr]{RETRY}} to retry the request.
}
\examples{
\dontrun{
  record <- list(ID=1, Value='One')
  dwapi::append_record_to_stream(owner_id = 'user',
    dataset_id = 'dataset', stream_id = 'mystream',
    record)
}
}
