% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findExcluded.R
\name{findExcluded}
\alias{findExcluded}
\title{Excluded individuals and pairings in a DVI dataset}
\usage{
findExcluded(
  dvi,
  maxIncomp = 2,
  pairings = NULL,
  ignoreSex = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{dvi}{A \code{\link[=dviData]{dviData()}} object.}

\item{maxIncomp}{An integer. A pairing is excluded if the number of
incompatible markers exceeds this.}

\item{pairings}{(Optional) A list of possible pairings for each victim. By
default, \code{dvi$pairings} is used, or, if this is NULL,
\code{generatePairings(dvi, ignoreSex = ignoreSex)}.}

\item{ignoreSex}{A logical, relevant only if both \code{pairings} and
\code{dvi$pairings} are NULL. Default: FALSE.}

\item{verbose}{A logical. Default: TRUE.}
}
\value{
A list with the following entries:
\itemize{
\item \code{exclusionMatrix}: A matrix showing the number of inconsistencies for
each pair (or NA if the pairing was not considered)
\item \code{excluded}: A list of three character vectors:
\itemize{
\item \code{sample}: victim samples excluded against all missing persons
\item \code{missing}: missing persons excluded against all victims
\item \code{fam}: families in which all missing members are excluded against
all victim samples
}
}

The above elements are removed in the reduced dataset.
\itemize{
\item \code{dviReduced}: A reduced version of \code{dvi}, where excluded victims/missing
persons are removed.
\item \code{report}: A list of data frames \code{PM} and \code{AM}, summarising the excluded
individuals.
}
}
\description{
Excluded individuals and pairings in a DVI dataset
}
\examples{
findExcluded(icmp)

}
\seealso{
\code{\link[=findUndisputed]{findUndisputed()}}
}
