% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_duckplyr_df.R
\name{as_duckplyr_df}
\alias{as_duckplyr_df}
\title{Convert to a duckplyr data frame}
\usage{
as_duckplyr_df(.data)
}
\arguments{
\item{.data}{data frame or tibble to transform}
}
\value{
An object of class \code{"duckplyr_df"}, inheriting from the classes of the
\code{.data} argument.
}
\description{
For an object of class \code{duckplyr_df},
dplyr verbs such as \code{\link[=mutate]{mutate()}}, \code{\link[=select]{select()}} or \code{\link[=filter]{filter()}}  will attempt to use DuckDB.
If this is not possible, the original dplyr implementation is used.
}
\details{
Set the \code{DUCKPLYR_FALLBACK_INFO} and \code{DUCKPLYR_FORCE} environment variables
for more control over the behavior, see \link{config} for more details.
}
\examples{
tibble(a = 1:3) \%>\%
  mutate(b = a + 1)

tibble(a = 1:3) \%>\%
  as_duckplyr_df() \%>\%
  mutate(b = a + 1)
}
