% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\docType{class}
\name{duckdb_connection-class}
\alias{duckdb_connection-class}
\alias{duckdb_connection}
\alias{show,duckdb_connection-method}
\alias{dbIsValid,duckdb_connection-method}
\alias{dbSendQuery,duckdb_connection,character-method}
\alias{dbDataType,duckdb_connection-method}
\alias{dbWriteTable,duckdb_connection,character,data.frame-method}
\alias{dbListTables,duckdb_connection-method}
\alias{dbExistsTable,duckdb_connection,character-method}
\alias{dbListFields,duckdb_connection,character-method}
\alias{dbRemoveTable,duckdb_connection,character-method}
\alias{dbGetInfo,duckdb_connection-method}
\alias{dbBegin,duckdb_connection-method}
\alias{dbCommit,duckdb_connection-method}
\alias{dbRollback,duckdb_connection-method}
\title{DuckDB connection class}
\usage{
\S4method{show}{duckdb_connection}(object)

\S4method{dbIsValid}{duckdb_connection}(dbObj, ...)

\S4method{dbSendQuery}{duckdb_connection,character}(conn, statement, ...)

\S4method{dbDataType}{duckdb_connection}(dbObj, obj, ...)

\S4method{dbWriteTable}{duckdb_connection,character,data.frame}(
  conn,
  name,
  value,
  row.names = FALSE,
  overwrite = FALSE,
  append = FALSE,
  field.types = NULL,
  temporary = FALSE,
  ...
)

\S4method{dbListTables}{duckdb_connection}(conn, ...)

\S4method{dbExistsTable}{duckdb_connection,character}(conn, name, ...)

\S4method{dbListFields}{duckdb_connection,character}(conn, name, ...)

\S4method{dbRemoveTable}{duckdb_connection,character}(conn, name, ...)

\S4method{dbGetInfo}{duckdb_connection}(dbObj, ...)

\S4method{dbBegin}{duckdb_connection}(conn, ...)

\S4method{dbCommit}{duckdb_connection}(conn, ...)

\S4method{dbRollback}{duckdb_connection}(conn, ...)
}
\arguments{
\item{object}{Any R object}

\item{dbObj}{An object inheriting from \linkS4class{DBIObject},
i.e. \linkS4class{DBIDriver}, \linkS4class{DBIConnection},
or a \linkS4class{DBIResult}}

\item{...}{Other arguments to methods.}

\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{statement}{a character string containing SQL.}

\item{obj}{An R object whose SQL type we want to determine.}

\item{name}{A character string specifying the unquoted DBMS table name,
or the result of a call to \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}.}

\item{value}{a \link{data.frame} (or coercible to data.frame).}

\item{row.names}{Whether the row.names of the data.frame should be preserved}

\item{overwrite}{If a table with the given name already exists, should it be overwritten?}

\item{append}{If a table with the given name already exists, just try to append the passed data to it}

\item{field.types}{Override the auto-generated SQL types}

\item{temporary}{Should the created table be temporary?}
}
\description{
Implements \linkS4class{DBIConnection}.
}
\keyword{internal}
