% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtwclust.R
\name{dtwclust}
\alias{dtwclust}
\title{Time series clustering}
\usage{
dtwclust(data = NULL, type = "partitional", k = 2L, method = "average",
  distance = "dtw_basic", centroid = "pam", preproc = NULL, dc = NULL,
  control = NULL, seed = NULL, distmat = NULL, ...)
}
\arguments{
\item{data}{A list of series, a numeric matrix or a data frame. Matrices and data frames are
coerced row-wise.}

\item{type}{What type of clustering method to use: \code{"partitional"}, \code{"hierarchical"}, \code{"tadpole"}
or \code{"fuzzy"}.}

\item{k}{Number of desired clusters. It may be a numeric vector with different values.}

\item{method}{Character vector with one or more linkage methods to use in hierarchical procedures
(see \code{\link[stats:hclust]{stats::hclust()}}) or a function that performs hierarchical clustering based on distance
matrices (e.g. \code{\link[cluster:diana]{cluster::diana()}}). See Hierarchical section for more details.}

\item{distance}{A supported distance from \code{\link[proxy:dist]{proxy::dist()}} (see Distance section). Ignored for
\code{type} = \code{"tadpole"}.}

\item{centroid}{Either a supported string or an appropriate function to calculate centroids when
using partitional or prototypes for hierarchical/tadpole methods. See Centroid section.}

\item{preproc}{Function to preprocess data. Defaults to \code{\link[=zscore]{zscore()}} \emph{only} if \code{centroid} \code{=}
\code{"shape"}, but will be replaced by a custom function if provided. See Preprocessing section.}

\item{dc}{Cutoff distance for the \code{\link[=TADPole]{TADPole()}} algorithm.}

\item{control}{Named list of parameters or \code{dtwclustControl} object for clustering algorithms.
See \link{dtwclustControl}. \code{NULL} means defaults.}

\item{seed}{Random seed for reproducibility.}

\item{distmat}{If a cross-distance matrix is already available, it can be provided here so it's
re-used. Only relevant if \code{centroid} = "pam" or \code{type} = "hierarchical". See examples.}

\item{...}{Additional arguments to pass to \code{\link[proxy:dist]{proxy::dist()}} or a custom function (preprocessing,
centroid, etc.)}
}
\value{
An object with formal class \linkS4class{dtwclust}.

If \code{control@nrep > 1} and a partitional procedure is used, \code{length(method)} \code{> 1} and
hierarchical procedures are used, or \code{length(k)} \code{>} \code{1}, a list of objects is returned.
}
\description{
This is the \strong{deprecated} function to perform time series clustering. See \code{\link[=tsclust]{tsclust()}} for the
new interface.
}
\details{
Partitional and fuzzy clustering procedures use a custom implementation. Hierarchical clustering
is done with \code{\link[stats:hclust]{stats::hclust()}}. TADPole clustering uses the \code{\link[=TADPole]{TADPole()}} function. Specifying
\code{type} = \code{"partitional"}, \code{distance} = \code{"sbd"} and \code{centroid} = \code{"shape"} is equivalent to the
k-Shape algorithm (Paparrizos and Gravano 2015).

The \code{data} may be a matrix, a data frame or a list. Matrices and data frames are coerced to a
list, both row-wise. Only lists can have series with different lengths or multiple dimensions.
Most of the optimizations require series to have the same length, so consider reinterpolating
them to save some time (see Ratanamahatana and Keogh 2004; \code{\link[=reinterpolate]{reinterpolate()}}). No missing values
are allowed.

In the case of multivariate time series, they should be provided as a list of matrices, where
time spans the rows of each matrix and the variables span the columns. At the moment, only \code{DTW},
\code{DTW2} and \code{GAK} support such series, which means only partitional and hierarchical procedures
using those distances will work. You can of course create your own custom distances. All included
centroid functions should work with the aforementioned format, although \code{shape} is \strong{not}
recommended. Note that the \code{plot} method will simply append all dimensions (columns) one after
the other.

Several parameters can be adjusted with the \code{control} argument. See \link{dtwclustControl}. In the
following sections, elements marked with an asterisk (*) are those that can be adjusted with this
argument.
}
\references{
Please refer to the package vignette references.
}
\author{
Alexis Sarda-Espinosa
}
\keyword{internal}
