% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtwclust-classes.R
\name{dtwclustControl-class}
\alias{dtwclustControl}
\alias{dtwclustControl-class}
\title{Class definition for \code{dtwclustControl}}
\description{
Formal S4 class with several control parameters used in \code{\link{dtwclust}}.
}
\details{
The included slots were some of the formal arguments of \code{\link{dtwclust}}.
In the next release, all arguments that correspond to one of the slots here will not be detected by the dtwclust function
unless specified in the \code{control} parameter.

Default values are shown at the end.
}
\section{Slots}{

\describe{
\item{\code{window.size}}{Integer or \code{NULL}. Window constraint for DTW and LB calculations. See Sakoe-Chiba section in
\code{\link{dtwclust}}.}

\item{\code{norm}}{Character. Pointwise distance for DTW, DBA and the LB. Either \code{"L1"} for Manhattan distance or \code{"L2"}
for Euclidean. Ignored for \code{distance = "DTW"} (which always uses \code{"L1"}) and
\code{distance = "DTW2"} (which always uses \code{"L2"}).}

\item{\code{trace}}{Logical flag. If \code{TRUE}, more output regarding the progress is printed to screen.}

\item{\code{save.data}}{Return a "copy" of the data in the returned object? Because of the way \code{R} handles
things internally, all copies should point to the same memory address.}

\item{\code{symmetric}}{Is the distance function symmetric? In other words, is \code{dist(x,y)} == \code{dist(y,x)}?
If \code{TRUE}, half the distance matrix can be computed and some time saved.}

\item{\code{packages}}{Character vector with the names of any packages required for custom \code{proxy} functions. See
Parallel Computing section in \code{\link{dtwclust}}.}

\item{\code{dba.iter}}{Integer. Maximum number of iterations for \code{\link{DBA}} centroids.}

\item{\code{pam.precompute}}{Logical flag. Precompute the whole distance matrix once and reuse it at each iteration if using PAM
centroids. Otherwise calculate distances at every iteration.}

\item{\code{iter.max}}{Integer. Maximum number of iterations.}

\item{\code{nrep}}{Integer. How many times to repeat partitional clustering with different starting points. See section Repetitions
in \code{\link{dtwclust}}.}
}}
\section{Common parameters}{


\itemize{
  \item \code{window.size} = \code{NULL}
  \item \code{norm} = "L1"
  \item \code{trace} = \code{FALSE}
  \item \code{save.data} = \code{TRUE}
  \item \code{symmetric} = \code{FALSE}
  \item \code{packages} = \code{character(0)}
}
}

\section{Only for partitional procedures}{


\itemize{
  \item \code{dba.iter} = \code{15L}
  \item \code{pam.precompute} = \code{TRUE}
  \item \code{iter.max} = \code{30L}
  \item \code{nrep} = \code{1L}
}
}

