% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.simulation.R
\name{run.simulation}
\alias{run.simulation}
\title{Method to run a simulation}
\usage{
run.simulation(
  simulation,
  run.parallel = FALSE,
  max.cores = NA,
  counter = TRUE,
  transect.path = character(0),
  progress.file = character(0)
)
}
\arguments{
\item{simulation}{\code{\link{Simulation-class}} object}

\item{run.parallel}{logical option to use multiple processors}

\item{max.cores}{integer maximum number of cores to use, if not specified then
one less than the number available will be used.}

\item{counter}{logical indicates if you would like to see the progress counter.}

\item{transect.path}{character gives the pathway to a folder of shapefiles or
the path to a single shapefile (.shp file) which give the transects which should
be used for the simulations. If a folder of transects a new shapefile will be
used for each repetition. If a path specifying a single shapefile then the same
transects will be used for each repetition.}

\item{progress.file}{character path with filename to output progress to file
for Distance for Windows progress counter. Not to be used when running directly
in R.}
}
\value{
the \code{\link{Simulation-class}} object which now includes
the results
}
\description{
Runs the simulation and returns the simulation object with results. If
running in parallel and max.cores is not specified it will default to using
one less than the number of cores / threads on your machine. For example
code see \code{\link{make.simulation}}
}
\seealso{
\code{\link{make.simulation}}
}
