% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\docType{class}
\name{Simulation-class}
\alias{Simulation-class}
\title{Class "Simulation"}
\description{
Class \code{"Simulation"} is an S4 class containing descriptions of the
region, population, survey design and analyses the user wishes to investigate.
Once the simulation has been run the N.D.Estimates will contain multiple
estimates of abundance and density obtained by repeatedly generating
populations, simulating the survey and completing the analyses.
}
\section{Slots}{

\describe{
\item{\code{reps}}{Object of class \code{"numeric"}; the number of
times the simulation should be repeated.}

\item{\code{single.transect.set}}{Object of class \code{"logical"}; if
\code{TRUE} the same set of transects are used in each repetition.}

\item{\code{design}}{Object of class \code{"Survey.Design"}; the
survey design.}

\item{\code{population.description}}{Object of class \code{"Population.Description"};
the population.description.}

\item{\code{detectability}}{Object of class \code{"Detectability"}; a
description of the detectability of the population.}

\item{\code{ds.analysis}}{Object of class \code{"DS.Analysis"}}

\item{\code{add.options}}{a list to expand simulation options in the future.}

\item{\code{ddf.param.ests}}{Object of class \code{"array"}; stores the
parameters associated with the detection function.}

\item{\code{results}}{A \code{"list"} of \code{"arrays"}; stores
the estimated of abundance and density as well as other measures
of interest.}

\item{\code{warnings}}{A \code{"list"} to store warnings and error messages encountered
during runtime.}
}}

\section{Methods}{

\describe{
 \item{\code{summary}}{\code{signature=(object = "Simulation")}: produces
 a summary of the simulation and its results.}
 \item{\code{generate.population}}{\code{signature = (object =
 "Simulation")}: generates a single instance of a population.}
 \item{\code{generate.transects}}{\code{signature = (object =
 "Simulation")}: generates a single set of transects.}
 \item{\code{run.survey}}{\code{signature = (object =
 "Simulation")}: carries out the simulation process as far as generating
 the distance data and returns an object containing the population,
 transects and data.}
 \item{\code{run.simulation}}{\code{signature = (simulation = "Simulation")}: runs
 the whole simulation for the specified number of repetitions.}
}
}

\seealso{
\code{\link{make.simulation}}
}
\keyword{classes}
