% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{list2derivs}
\alias{list2derivs}
\title{list2derivs}
\usage{
list2derivs(f, deriv_order)
}
\arguments{
\item{f}{list of matrices; d0, d1, d2, d3, d4}

\item{deriv_order}{integer; maximum order of derivative. Available are \code{0},\code{2} and \code{4}.}
}
\value{
Mostly internal function. Returns an object of class \code{derivs}
For more details see [trind()] and [trind_generator()].
}
\description{
Transforms a list of matrices d0, d1, d2, d3, d4 to a \code{derivs} object.
}
\examples{
A<-matrix(c(1:9)/10, ncol=3)
list2derivs(list(A, A^0, A^2, A^3, A^4), deriv_order=4)

}
\seealso{
Other derivs: 
\code{\link{chainrule}()},
\code{\link{derivs_transform}()},
\code{\link{differencerule}()},
\code{\link{ind2joint}()},
\code{\link{productrule}()},
\code{\link{quotientrule}()},
\code{\link{sumrule}()},
\code{\link{trind_generator}()},
\code{\link{trind}()}
}
\concept{derivs}
