% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutateDS.R
\name{mutateDS}
\alias{mutateDS}
\title{Create, modify, and delete columns}
\usage{
mutateDS(tidy_expr, df.name, .keep = NULL, .before = NULL, .after = NULL)
}
\arguments{
\item{tidy_expr}{Name-value pairs. The name gives the name of the column in the output.}

\item{df.name}{A data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}

\item{.keep}{.keep Control which columns from \code{df.name} are retained in the output. Grouping
columns and columns created by \code{tidy_expr} are always kept.
\itemize{
  \item \code{"all"}: Retains all columns from \code{df.name}. This is the default.
  \item \code{"used"}: Retains only the columns used in \code{tidy_expr} to create new columns.
  \item \code{"unused"}: Retains only the columns not used in \code{tidy_expr} to create new columns. This is useful if you generate new columns but no longer need the columns used to generate them.
  \item \code{"none"}: Doesn't retain any extra columns from \code{df.name}. Only the grouping variables and columns created by \code{tidy_expr} are kept.
}
Grouping columns and columns created by \code{tidy_expr} are always kept.}

\item{.before}{<tidy-select> Optionally, control where new columns should appear (the default is
to add to the right hand side). See \code{relocate} for more details.}

\item{.after}{<tidy-select> Optionally, control where new columns should appear (the default is
to add to the right hand side). See \code{relocate} for more details.}
}
\value{
An object of the same type as \code{df.name}, typically a data frame or tibble.
}
\description{
DataSHIELD implentation of \code{mutate}.
}
