% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{map_text_coord}
\alias{map_text_coord}
\title{map_text_coord maps the characters of a text string into a table (with x/y-coordinates).}
\usage{
map_text_coord(x, flip_y = FALSE, sep = "")
}
\arguments{
\item{x}{The text string(s) to map (required). 
If \code{length(x) > 1}, elements are mapped to different lines 
(i.e., y-coordinates).}

\item{flip_y}{Boolean: Should y-coordinates be flipped, 
so that the lowest line in the text file becomes \code{y = 1}, 
and the top line in the text file becomes \code{y = n_lines}? 
Default: \code{flip_y = FALSE}.}

\item{sep}{Character to insert between the elements 
of a multi-element character vector as input \code{x}? 
Default: \code{sep = ""} (i.e., add nothing).}
}
\value{
A data frame with 3 variables: 
Each character's \code{x}- and \code{y}-coordinates (from top to bottom)  
and a variable \code{char} for the character at this coordinate.
}
\description{
\code{map_text_coord} parses text (from a text string \code{x}) 
into a table that contains a row for each character 
and x/y-coordinates corresponding to the character positions in \code{x}.
}
\details{
\code{map_text_coord} creates a data frame with 3 variables: 
Each character's \code{x}- and \code{y}-coordinates (from top to bottom)  
and a variable \code{char} for the character at these coordinates. 

Note that \code{map_text_coord} was originally a part of 
\code{\link{read_ascii}}, but has been separated to 
enable independent access to separate functionalities.
}
\examples{
map_text_coord("Hello world!")             # 1 line of text
map_text_coord(c("Hello", "world!"))       # 2 lines of text
map_text_coord(c("Hello", " ", "world!"))  # 3 lines of text
 
\donttest{
## Read text from file:

## Create a temporary file "test.txt":
# cat("Hello world!", "This is a test.",
#     "Can you see this text?", "Good! Please carry on...",
#      file = "test.txt", sep = "\n")
 
# txt <- read_ascii("test.txt")
# map_text_coord(txt)

# unlink("test.txt")  # clean up (by deleting file). 
}

}
\seealso{
\code{\link{map_text_regex}} for mapping text to a character table and matching patterns; 
\code{\link{plot_charmap}} for plotting character maps; 
\code{\link{plot_chars}} for creating and plotting character maps; 
\code{\link{read_ascii}} for parsing text from file or user input.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{count_chars_words}()},
\code{\link{count_chars}()},
\code{\link{count_words}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_chars}()},
\code{\link{map_text_regex}()},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_chars}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()}
}
\concept{text objects and functions}
