% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_fun.R
\name{is_leap_year}
\alias{is_leap_year}
\title{Is some year a so-called leap year?}
\source{
See \url{https://en.wikipedia.org/wiki/Leap_year} for definition.
}
\usage{
is_leap_year(dt)
}
\arguments{
\item{dt}{Date or time (scalar or vector). 
Numbers or strings with dates are parsed into 
4-digit numbers denoting the year}
}
\description{
\code{is_leap_year} checks whether a given year 
(provided as a date or time \code{dt}, 
or number/string denoting a 4-digit year)  
lies in a so-called leap year (i.e., a year containing a date of Feb-29).
}
\details{
When \code{dt} is not recognized as "Date" or "POSIXt" object(s), 
\code{is_leap_year} aims to parse a string \code{dt} 
as describing year(s) in a "dddd" (4-digit year) format,  
as a valid "Date" string (to retrieve the 4-digit year "\%Y"), 
or a numeric \code{dt} as 4-digit integer(s). 

\code{is_leap_year} then solves the task in two ways:  
1. by verifying the numeric definition of a "leap year", and 
2. by trying to use \code{as.Date()} for defining 
a "Date" of Feb-29 in the corresponding year(s).
}
\examples{
is_leap_year(2020)

# from dates:
is_leap_year(Sys.Date())
is_leap_year(as.Date("2022-02-28"))

# from times:
is_leap_year(Sys.time())
is_leap_year(as.POSIXct("2022-10-11 10:11:12"))
is_leap_year(as.POSIXlt("2022-10-11 10:11:12"))

# from non-integers:
is_leap_year(2019.5)

# For vectors:
is_leap_year(2020:2028)

# with dt as strings:
is_leap_year(c("2020", "2021"))
is_leap_year(c("2020-02-29 01:02:03", "2021-02-28 01:02"))
# Note: Invalid date string would yield error
# is_leap_year("2021-02-29")


}
\seealso{
\code{leap_year} function of the \strong{lubridate} package.

Other date and time functions: 
\code{\link{change_time}()},
\code{\link{change_tz}()},
\code{\link{cur_date}()},
\code{\link{cur_time}()},
\code{\link{what_date}()},
\code{\link{what_day}()},
\code{\link{what_month}()},
\code{\link{what_time}()},
\code{\link{what_week}()},
\code{\link{what_year}()}
}
\concept{date and time functions}
