test_that("printing optimization results", {
  res <- optimal_normal(
    w = 0.3,
    Delta1 = 0.375,
    Delta2 = 0.625,
    in1 = 300,
    in2 = 600,
    a = 0.25,
    b = 0.75,
    n2min = 20,
    n2max = 100,
    stepn2 = 4,
    kappamin = 0.02,
    kappamax = 0.2,
    stepkappa = 0.02,
    alpha = 0.05,
    beta = 0.1,
    c2 = 0.675,
    c3 = 0.72,
    c02 = 15,
    c03 = 20,
    K = Inf,
    N = Inf,
    S = -Inf,
    steps1 = 0,
    stepm1 = 0.5,
    stepl1 = 0.8,
    b1 = 3000,
    b2 = 8000,
    b3 = 10000,
    gamma = 0,
    fixed = FALSE,
    skipII = FALSE,
    num_cl = 1
  )
  expect_equal(
    capture_output_lines(print(res)),
    c(
      "Optimization result:",
      " Utility: 2272.13",
      " Sample size:",
      "   phase II: 100, phase III: 350, total: 450",
      " Probability to go to phase III: 0.94" ,
      " Total cost:"  ,
      "   phase II: 82, phase III: 271, cost constraint: Inf" ,
      " Fixed cost:",
      "   phase II: 15, phase III: 20",
      " Variable cost per patient:",
      "   phase II: 0.675, phase III: 0.72",
      " Effect size categories (expected gains):",
      "  small: 0 (3000), medium: 0.5 (8000), large: 0.8 (10000)",
      " Success probability: 0.78",
      " Success probability by effect size:" ,
      "   small: 0.73, medium: 0.05, large: 0",
      " Significance level: 0.05",
      " Targeted power: 0.9",
      " Decision rule threshold: 0.08 [Kappa] ",
      " Parameters of the prior distribution: ",
      "   Delta1: 0.375, Delta2: 0.625, in1: 300, in2: 600,",
      "   a: 0.25, b: 0.75, w: 0.3",
      " Treatment effect offset between phase II and III: 0 [gamma] "
    )
  )
})
