% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_bias_normal.R
\name{optimal_bias_normal}
\alias{optimal_bias_normal}
\title{Optimal phase II/III drug development planning when discounting phase II results with normally distributed endpoint}
\usage{
optimal_bias_normal(
  w,
  Delta1,
  Delta2,
  in1,
  in2,
  a,
  b,
  n2min,
  n2max,
  stepn2,
  kappamin,
  kappamax,
  stepkappa,
  adj = "both",
  lambdamin = NULL,
  lambdamax = NULL,
  steplambda = NULL,
  alphaCImin = NULL,
  alphaCImax = NULL,
  stepalphaCI = NULL,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K = Inf,
  N = Inf,
  S = -Inf,
  steps1 = 0,
  stepm1 = 0.5,
  stepl1 = 0.8,
  b1,
  b2,
  b3,
  fixed = FALSE,
  num_cl = 1
)
}
\arguments{
\item{w}{weight for
\href{https://web.imbi.uni-heidelberg.de/prior/}{mixture prior distribution}}

\item{Delta1}{assumed true prior treatment effect measured as the
standardized difference in means, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here} for details}

\item{Delta2}{assumed true prior treatment effect measured as the
standardized difference in means, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here} for details}

\item{in1}{amount of information for \code{Delta1} in terms of sample size, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{in2}{amount of information for \code{Delta2} in terms of sample size, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{a}{lower boundary for the truncation of the \href{https://web.imbi.uni-heidelberg.de/prior/}{prior distribution}}

\item{b}{upper boundary for the truncation of the \href{https://web.imbi.uni-heidelberg.de/prior/}{prior distribution}}

\item{n2min}{minimal total sample size for phase II; must be an even number}

\item{n2max}{maximal total sample size for phase II, must be an even number}

\item{stepn2}{step size for the optimization over n2; must be an even number}

\item{kappamin}{minimal threshold value kappa for the go/no-go decision rule}

\item{kappamax}{maximal threshold value  kappa for the go/no-go decision rule}

\item{stepkappa}{step size for the optimization over the threshold value kappa}

\item{adj}{choose type of adjustment: \code{"multiplicative"},
\code{"additive"}, \code{"both"} or \code{"all"}. When using "both",
\code{res[1,]} contains the results using the multiplicative method and \code{res[2,]}
contains the results using the additive method. When using "all", there are
also \code{res[3,]} and \code{res[4,]}, containing the results of a multiplicative
and an additive method which do not only adjust the treatment effect but
also the threshold value for the decision rule.}

\item{lambdamin}{minimal multiplicative adjustment parameter lambda (i.e. use estimate with a retention factor)}

\item{lambdamax}{maximal multiplicative adjustment parameter lambda (i.e. use estimate with a retention factor)}

\item{steplambda}{stepsize for the adjustment parameter lambda}

\item{alphaCImin}{minimal additive adjustment parameter alphaCI (i.e. adjust the lower bound of the one-sided confidence interval)}

\item{alphaCImax}{maximal additive adjustment parameter alphaCI (i.e. adjust the lower bound of the one-sided confidence interval)}

\item{stepalphaCI}{stepsize for alphaCI}

\item{alpha}{one-sided significance level}

\item{beta}{type II error rate; i.e. \code{1 - beta} is the power for calculation of the sample size for phase III}

\item{c2}{variable per-patient cost for phase II in 10^5 $}

\item{c3}{variable per-patient cost for phase III in 10^5 $}

\item{c02}{fixed cost for phase II in 10^5 $}

\item{c03}{fixed cost for phase III in 10^5 $}

\item{K}{constraint on the costs of the program, default: Inf, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: Inf, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: -Inf, e.g. no constraint}

\item{steps1}{lower boundary for effect size category "small", default: 0}

\item{stepm1}{lower boundary for effect size category "medium" = upper boundary for effect size category "small" default: 0.5}

\item{stepl1}{lower boundary for effect size category "large" = upper boundary for effect size category "medium", default: 0.8}

\item{b1}{expected gain for effect size category "small" in 10^5 $}

\item{b2}{expected gain for effect size category "medium" in 10^5 $}

\item{b3}{expected gain for effect size category "large" in 10^5 $}

\item{fixed}{choose if true treatment effects are fixed or following a prior distribution, if TRUE \code{Delta1} is used as fixed effect}

\item{num_cl}{number of clusters used for parallel computing, default: 1}
}
\value{
The output of the function is a \code{data.frame} object containing the optimization results:
\describe{\item{Method}{Type of adjustment: "multipl." (multiplicative adjustment of effect size), "add." (additive adjustment of effect size), "multipl2." (multiplicative adjustment of effect size and threshold), "add2." (additive adjustment of effect size and threshold)}
\item{Adj}{optimal adjustment parameter (lambda or alphaCI according to Method)}\item{u}{maximal expected utility under the optimization constraints, i.e. the expected utility of the optimal sample size and threshold value}\item{Kappa}{optimal threshold value for the decision rule to go to phase III}\item{n2}{total sample size for phase II; rounded to the next even natural number}
\item{n3}{total sample size for phase III; rounded to the next even natural number}
\item{n}{total sample size in the program; n = n2 + n3}
\item{K}{maximal costs of the program (i.e. the cost constraint, if it is set or the sum K2+K3 if no cost constraint is set)}
\item{pgo}{probability to go to phase III}
\item{sProg}{probability of a successful program}\item{sProg1}{probability of a successful program with "small" treatment effect in phase III}
\item{sProg2}{probability of a successful program with "medium" treatment effect in phase III}
\item{sProg3}{probability of a successful program with "large" treatment effect in phase III}\item{K2}{expected costs for phase II}
\item{K3}{expected costs for phase III}}
and further input parameters. Taking \code{cat(comment())} of the
data frame lists the used optimization sequences, start and
finish date of the optimization procedure.
}
\description{
The function \code{\link{optimal_bias_normal}} of the drugdevelopR package enables planning of phase II/III drug development programs with optimal sample size allocation and go/no-go decision rules including methods for discounting of phase II results for normally distributed endpoints (Preussler et. al, 2020).
The discounting may be necessary as programs that proceed to phase III can be overoptimistic about the treatment effect (i.e. they are biased).
The assumed true treatment effects can be assumed fixed or modelled by a prior distribution.
The R Shiny application \href{https://web.imbi.uni-heidelberg.de/prior/}{prior} visualizes the prior distributions used in this package.
Fast computing is enabled by parallel programming.
}
\examples{
# Activate progress bar (optional)
\dontrun{progressr::handlers(global = TRUE)}
# Optimize
\donttest{
optimal_bias_normal(w=0.3,             # define parameters for prior
  Delta1 = 0.375, Delta2 = 0.625, in1=300, in2=600,    # (https://web.imbi.uni-heidelberg.de/prior/)
  a = 0.25, b = 0.75,
  n2min = 20, n2max = 100, stepn2 = 10,                # define optimization set for n2
  kappamin = 0.02, kappamax = 0.2, stepkappa = 0.02,   # define optimization set for kappa
  adj = "both",                                        # choose type of adjustment
  lambdamin = 0.2, lambdamax = 1, steplambda = 0.05,   # define optimization set for lambda
  alphaCImin = 0.025, alphaCImax = 0.5,
  stepalphaCI = 0.025,                                 # define optimization set for alphaCI
  alpha = 0.025, beta = 0.1,                           # drug development planning parameters
  c2 = 0.675, c3 = 0.72, c02 = 15, c03 = 20,           # fixed and variable costs for phase II/III
  K = Inf, N = Inf, S = -Inf,                          # set constraints
  steps1 = 0,                                          # define lower boundary for "small"
  stepm1 = 0.5,                                        # "medium"
  stepl1 = 0.8,                                        # and "large" effect size categories
  b1 = 3000, b2 = 8000, b3 = 10000,                    # define expected benefits
  fixed = TRUE,                                        # true treatment effects are fixed/random
  num_cl = 1)                                          # number of coresfor parallelized computing 
  }                                        
}
\references{
Cohen, J. (1988). Statistical power analysis for the behavioral sciences.
}
