% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_tte.R
\name{Epgo_tte}
\alias{Epgo_tte}
\title{Expected probability to go to phase III for time-to-event outcomes}
\usage{
Epgo_tte(HRgo, d2, w, hr1, hr2, id1, id2, fixed)
}
\arguments{
\item{HRgo}{threshold value for the go/no-go decision rule}

\item{d2}{total number of events for phase II; must be even number}

\item{w}{weight for mixture prior distribution}

\item{hr1}{first assumed true treatment effect on HR scale for prior distribution}

\item{hr2}{second assumed true treatment effect on HR scale for prior distribution}

\item{id1}{amount of information for \code{hr1} in terms of number of events}

\item{id2}{amount of information for \code{hr2} in terms of number of events}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE \code{hr1} is used as fixed effect}
}
\value{
The output of the functions \code{Epgo_tte()} is the expected probability to go to phase III.
}
\description{
Expected probability to go to phase III for time-to-event outcomes
}
\examples{
res <- Epgo_tte(HRgo = 0.8, d2 = 50,  
                                w = 0.3, hr1 = 0.69, hr2 = 0.81, 
                                id1 = 280, id2 = 420, fixed = FALSE)
}
\keyword{internal}
