% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mannwhitney_fn.R
\name{estimate_ci_mannwhitney}
\alias{estimate_ci_mannwhitney}
\title{Compute confidence interval/s for the Mann-Whitney parameter}
\usage{
estimate_ci_mannwhitney(
  mannwhitney_est,
  cdf_est,
  pmf_est,
  treat_prob_est,
  treat_form,
  out_form,
  treat,
  ci,
  out,
  alpha,
  nboot,
  out_levels,
  covar,
  out_model
)
}
\arguments{
\item{mannwhitney_est}{The point estimates for log-odds.}

\item{cdf_est}{The estimated conditional CDF.}

\item{pmf_est}{The estimated conditional PMF.}

\item{treat_prob_est}{Estimated probability of treatments, output from call
to \code{estimate_treat_prob}.}

\item{treat_form}{The right-hand side of a regression formula for the working model of
treatment probability as a function of covariates}

\item{out_form}{The right-hand side of a regression formula for the working proportional 
odds model. NOTE: THIS FORMULA MUST NOT SUPPRESS THE INTERCEPT.}

\item{treat}{A \code{numeric} vector containing treatment status. Missing
values are not allowed unless the corresponding entry in \code{out} is also missing. 
Only values of 0 or 1 are treated as actual treatment levels. Any other value is assumed 
to encode a value for which the outcome is missing and the corresponding outcome value is 
ignored.}

\item{ci}{A vector of \code{characters} indicating which confidence intervals
should be computed (\code{"bca"} and/or \code{"wald"})}

\item{out}{A \code{numeric} vector containing the outcomes. Missing outcomes are 
allowed.}

\item{alpha}{Confidence intervals have nominal level 1-\code{alpha}.}

\item{nboot}{Number of bootstrap replicates used to compute bootstrap confidence
intervals.}

\item{out_levels}{A \code{numeric} vector containing all ordered levels of the 
outcome.}

\item{covar}{A \code{data.frame} containing the covariates to include in the working
proportional odds model.}

\item{out_model}{Which R function should be used to fit the proportional odds 
model. Options are \code{"polr"} (from the \code{MASS} package), 
"vglm" (from the \code{VGAM} package), or \code{"clm"} (from the \code{ordinal} package).}
}
\value{
List with \code{wald} and \code{bca}-estimated confidence intervals 
for the Mann-Whitney parameter.
}
\description{
Compute confidence interval/s for the Mann-Whitney parameter
}
