% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglogistic2.R
\name{loglogistic2_fn}
\alias{loglogistic2_fn}
\title{2-parameter log-logistic function}
\usage{
loglogistic2_fn(x, theta)
}
\arguments{
\item{x}{numeric vector at which the function is to be evaluated.}

\item{theta}{numeric vector with the four parameters in the form
\code{c(alpha, delta, eta, phi)}. \code{alpha} can only be equal to 0 or 1 while
\code{delta} can only be equal to 1 or -1.}
}
\value{
Numeric vector of the same length of \code{x} with the values of the
log-logistic function.
}
\description{
Evaluate at a particular set of parameters the 2-parameter log-logistic
function.
}
\details{
The 2-parameter log-logistic function \verb{f(x; theta)} is defined here as

\verb{g(x; theta) = x^eta / (x^eta + phi^eta)}
\verb{f(x; theta) = alpha + delta g(x; theta)}

where \code{x >= 0}, \code{theta = c(alpha, delta, eta, phi)}, \code{eta > 0}, and
\code{phi > 0}. Only \code{eta} and \code{phi} are free to vary (therefore the name) while
vector \code{c(alpha, delta)} is constrained to be either \code{c(0, 1)} (monotonically
increasing curve) or \code{c(1, -1)} (monotonically decreasing curve).

This function allows values other than \verb{\{0, 1, -1\}} for \code{alpha} and \code{delta}
but will coerce them to their proper constraints.
}
