% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\docType{package}
\name{dr4pl}
\alias{dr4pl}
\alias{dr4pl-package}
\alias{dr4pl}
\alias{dr4pl.formula}
\alias{dr4pl.default}
\title{Fitting 4 Parameter Logistic (4PL) models to dose-response data.}
\usage{
dr4pl(...)

\method{dr4pl}{formula}(formula, data = list(), init.parm = NULL,
  trend = "auto", method.init = "Mead", method.robust = NULL,
  method.optim = "Nelder-Mead", use.Hessian = FALSE, level = 0.9999,
  failure.message = FALSE, ...)

\method{dr4pl}{default}(dose, response, init.parm = NULL, trend = "auto",
  method.init = "Mead", method.robust = NULL,
  method.optim = "Nelder-Mead", use.Hessian = FALSE, level = 0.9999,
  failure.message = FALSE, ...)
}
\arguments{
\item{...}{Further arguments to be passed to \code{constrOptim}.}

\item{formula}{Symbolic description of the model to be fit. Either of the
form 'response ~ dose' or as a data frame with response values in first
column and dose values in second column.}

\item{data}{Data frame containing variables in the model.}

\item{init.parm}{Vector of initial parameters to be optimized in the model.}

\item{trend}{Indicator of whether a dose-response curve is a decreasing 
\eqn{\theta[3]<0} or increasing curve \eqn{\theta[3]>0}. The default is "auto" 
which indicates that the trend of the curve is automatically determined by
data. The option "decreasing" will impose a restriction \eqn{\theta[3]<=0} 
while the option "increasing" will impose a restriction \eqn{\theta[3]>=0} in an 
optimization process.}

\item{method.init}{Method of obtaining initial values of the parameters.
If this parameter is left unassigned, a default "Mead" method will be used.
Assign "logistic" to use the logistic method.}

\item{method.robust}{Parameter to select loss function for the robust estimation 
method to be used to fit a model. The argument NULL indicates the sum of squares
loss, "absolute" indicates the absolute deviation loss, "Huber" indicates Huber's
loss and "Tukey" indicates Tukey's biweight loss.}

\item{method.optim}{Method of optimization of the loss function specified by
\code{method.robust}. This function argument is directly passed to the function
\code{\link[stats]{constrOptim}} which is provided in the \pkg{base} package of R.}

\item{use.Hessian}{Indicator of whether the Hessian matrix (TRUE) or the
gradient vector is used in the Hill bounds.}

\item{level}{Confidence level to be used in Hill bounds computation.}

\item{failure.message}{Indicator of whether a message indicating attainment of
the Hill bounds and possible resolutions will be printed to the console (TRUE)
or hidden (FALSE).}

\item{dose}{Vector of dose levels}

\item{response}{Vector of responses}
}
\value{
A 'dr4pl' object for which "confint", "gof", "print" and "summary"
  methods are implemented. For details, see the help page of each method.
  For example, type \code{?confint.dr4pl} to obtain the confidence intervals
  of parameters of the 'dr4pl' object.
}
\description{
This function fits a 4PL model to dose-response data. Users can
obtain fitted parameter estimates as return values. Using auxiliary functions
provided by this R package, users can plot a fitted dose-response curve and
obtain confidence intervals of true parameters. In addition, the goodness-of-fit
test for model adequacy of the 4PL models can be performed when replicates are
available for each dose level.
}
\details{
This function fits a 4 parameter logistic (4PL) model to dose-response
  data. A formula of the model is
  \deqn{\theta[1]+(\theta[4]-\theta[1])/(1+(z/\theta[2])^\theta[3])}

  \code{method.init} specifies an initialization method to get initial parameter
  estimates based on data. The currently supported initialization methods are
  "logistic" and 'Mead'. For further details, see the vignette.

  \code{method.optim} specifies an optimization method to be used in
  "constrOptim" function. The currently supported optimization techniques
  include "Nelder-Mead", "BFGS", "CG", "L-BFGS-B", "SANN" and "Brent". For
  further details, see the help page of \code{\link[stats]{optim}}.

  \code{method.robust} chooses a robust estimation method among 4 methods.
  The method of estimation is usually identified by the loss function of the
  method. This package supports 4 types of loss functions: sum-of-squares loss,
  absolute deviation loss, Huber's loss and Tukey's biweight loss. Each of
  loss function is explained in detail in the vignette.
}
\section{Methods (by class)}{
\itemize{
\item \code{formula}: General 4PL model fitting function for analysis of
dose-response relation.

\item \code{default}: Used in the default case, supplying a single dose and 
response variable
}}

\examples{
  ##Assign method.init = "logistic" to use logistic method of estimation.
  a <- dr4pl(dose = sample_data_1$Dose, 
               response = sample_data_1$Response, 
               method.init = "logistic")
  plot(a)

  ##Use default or Assign method.init = "Mead" to use Mead's method of estimation.
  # Use method.robust to select desired loss function
  b <- dr4pl(Response~Dose, 
               data = sample_data_4,
               method.init = "Mead", 
               method.robust = "Tukey" )
  plot(b)

  ##compatable with ggplot
  library(ggplot2) #load ggplot2
  c <- dr4pl(Response~Dose, 
          data = drc_error_2, 
          method.optim = "CG", 
          trend = "decreasing" )
  d <- plot(c, x.breaks = c(.00135, .0135, .135, 1.35, 13.5))
  d + theme_grey()
}
\seealso{
\code{\link{confint.dr4pl}}, \code{\link{gof.dr4pl}},
\code{\link{print.dr4pl}}, \code{\link{summary.dr4pl}}
}
\author{
Hyowon An, \email{ahwbest@gmail.com}

Justin T. Landis, \email{jtlandis314@gmail.com}

Aubrey G. Bailey, \email{aubreybailey@gmail.com}
}
