% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tbl-sql.r
\name{copy_to.src_sql}
\alias{copy_to.src_sql}
\title{Copy a local data frame to a sqlite src.}
\usage{
\method{copy_to}{src_sql}(dest, df, name = deparse(substitute(df)),
  types = NULL, temporary = TRUE, indexes = NULL, analyze = TRUE, ...)
}
\arguments{
\item{dest}{remote data source}

\item{df}{local data frame}

\item{name}{name for new remote table.}

\item{types}{a character vector giving variable types to use for the columns.
See \url{http://www.sqlite.org/datatype3.html} for available types.}

\item{temporary}{if \code{TRUE}, will create a temporary table that is
local to this connection and will be automatically deleted when the
connection expires}

\item{indexes}{a list of character vectors. Each element of the list
will create a new index.}

\item{analyze}{if \code{TRUE} (the default), will automatically ANALYZE the
new table so that the query optimiser has useful information.}

\item{...}{other parameters passed to methods.}
}
\value{
a sqlite \code{\link{tbl}} object
}
\description{
This standard method works for all sql sources.
}
\examples{
if (requireNamespace("RSQLite")) {
db <- src_sqlite(tempfile(), create = TRUE)

iris2 <- copy_to(db, iris)
mtcars$model <- rownames(mtcars)
mtcars2 <- copy_to(db, mtcars, indexes = list("model"))

explain(filter(mtcars2, model == "Hornet 4 Drive"))

# Note that tables are temporary by default, so they're not
# visible from other connections to the same database.
src_tbls(db)
db2 <- src_sqlite(db$path)
src_tbls(db2)
}
}

