% Generated by roxygen2 (4.0.1): do not edit by hand
\name{tally}
\alias{tally}
\title{Tally observations by group.}
\usage{
tally(x, wt, sort = FALSE)
}
\arguments{
\item{x}{a \code{\link{tbl}} to tally}

\item{wt}{if not specified, will tally the number of rows. If specified,
will perform a "weighted" tally but summing over the specified variable.}

\item{sort}{if \code{TRUE} will sort output in descending order of \code{n}}
}
\description{
\code{tally} is a convenient wrapper for summarise that will either call
\code{\link{n}} or \code{\link{sum}(n)} depending on whether you're tallying
for the first time, or re-tallying.
}
\examples{
library(Lahman)
batting_tbl <- tbl_df(Batting)
tally(group_by(batting_tbl, yearID))
tally(group_by(batting_tbl, yearID), sort = TRUE)

# Multiple tallys progressively role up the groups
plays_by_year <- tally(group_by(batting_tbl, playerID, stint), sort = TRUE)
tally(plays_by_year, sort = TRUE)
tally(tally(plays_by_year))

# This looks a little nicer if you use the infix \%>\% operator
batting_tbl \%>\% group_by(playerID) \%>\% tally(sort = TRUE)
}

