% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{dkprofile}
\alias{dkprofile}
\title{cumulative profile, its slope and the area under its curve}
\usage{
dkprofile(
  x,
  type = "cartesian",
  xlab = paste("cumulated frequency (\%)"),
  ylab = "",
  main = "",
  col = "red",
  alpha = 1,
  size = 1,
  linetype = "solid"
)
}
\arguments{
\item{x}{a numeric vector}

\item{type}{a character string indicating the type of coordinates to use
("cartesian", "polar" etc.). Currently only "cartesian" is supported.}

\item{xlab}{title of the x axis}

\item{ylab}{title of the y axis}

\item{main}{main title of the plot}

\item{col}{the color of data points}

\item{alpha}{numeric indicating the alpha value of data points}

\item{size}{the size of data points}

\item{linetype}{the type of line to be traced (see ggplot2)}
}
\value{
A list containing (1) the area under the curve of the profile, (2) the profile to be drawn,
and (3) the slope of the profile at the mean of the variable.
}
\description{
A function for drawing the cumulative profile of a variable, computing the area under the curve and
the slope of the profile at the arithmetic mean of the variable.
}
\examples{
#Elevation (hypsometric) profile (see Thiery et al., 2017):
dkprofile(elev(dkpongo$OES), main = "Elevation profile - Pongo pygmaeus",
ylab = "Elevation (\%)", col = "#0072B2", linetype = "solid")

#Enamel-dentine distance (pachymetric) profile:
dkprofile(oedist(dkpongo$OES, dkpongo$EDJ),
main = "Elevation profile - Pongo pygmaeus", ylab = "Distance (\%)",
col = "#F0E442", linetype = "dashed")

#Curvature (kurtometric) profile:
dkprofile(Rvcg::vcgCurve(dkpongo$OES)$meanitmax,
main = "Curvature profile - Pongo pygmaeus", ylab = "Curvature (\%)",
col = "#D55E00", linetype = "dotted")

}
\references{
\doi{10.3389/fphys.2017.00524}{Thiery et al. (2017)}
}
