% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report}
\alias{report}
\alias{report_num}
\alias{report_txt}
\alias{report_fct}
\title{Fetch EDA of a specific type of column}
\usage{
report_num(res, group = "")

report_txt(res, group = "")

report_fct(res, group = "")
}
\arguments{
\item{res}{A list returned from \code{examine()}}

\item{group}{Group from which to retrieve summary
(see \code{vignette("doctr_examine")} for more
information)}
}
\description{
Returns table with summary statistics of \code{X}'s
  numeric|text|factor variables (based on results from \code{examine(X)})
}
\details{
This function uses the result of \code{examine()}'s
  execution to generate a report on a table's numeric|text|factor
  variables; it is also able to retrieve the results
  from only one group given that \code{examine()}
  was used with its \code{group} argument
}
\examples{
\dontrun{
library(tidyverse)
  
# Getting EDA for numeric and text variables
txhousing \%>\% examine() \%>\% report_num()
txhousing \%>\% examine() \%>\% report_txt()
  
# Getting EDA with grouping (of a factor variable)
txhousing \%>\%
  mutate(city = as.factor(city)) \%>\%
  examine(1) \%>\%
  report_fct("Austin")
}

}
