% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{select}
\alias{select}
\alias{select.character}
\alias{select.numeric}
\alias{select.logical}
\alias{select.data.frame}
\alias{select.matrix}
\alias{select.list}
\title{Subset data
Take subset data for}
\usage{
select(data, i, ...)

\method{select}{character}(data, i, ...)

\method{select}{numeric}(data, i, ...)

\method{select}{logical}(data, i, ...)

\method{select}{data.frame}(data, i, j, drop = FALSE, ...)

\method{select}{matrix}(data, i, j, drop = FALSE, ...)

\method{select}{list}(data, i, j, drop = FALSE, ...)
}
\arguments{
\item{data}{one vector, list, dataframe or matrix}

\item{i}{element position for vector or list, row number for dataframe or matrix}

\item{...}{ignore}

\item{j}{column number for dataframe or matrix}

\item{drop}{logical, whether to drop original format, default is FALSE}
}
\value{
selected data
}
\description{
Subset data
Take subset data for
}
\examples{
x <- c('ab','bc','d')
x |> select(!grepl('a'))
x |> select(grepl('a'))
x |> select(!grepl('a'))
x |> select(grepl('a'))

x <- mtcars
x |> select(,!grepl('m',ignore.case = TRUE))
x |> select(grepl('m',ignore.case = TRUE),grepl('m',ignore.case = TRUE))
x |> select(!grepl('m',ignore.case = TRUE),!grepl('m',ignore.case = TRUE))

x |> select(grepl('a') & grepl('m'))
x |> select(grepl('a|m'))
x |> select(am ==1)
}
